package com.icetech.basics.utils;

import org.apache.commons.lang3.RandomUtils;

/**
 * KEY加盐
 */
public class KeySlatUtils {

    private static final char[] SLAT_STR = { 'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', 'a', 's', 'd', 'f', 'g',
            'h', 'j', 'k', 'l', 'z', 'x', 'c', 'v', 'b', 'n', 'm', '8', '5', '2', '7', '3', '6', '4', '0', '9', '1',
            'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', 'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'Z', 'X',
            'C', 'V', 'B', 'N', 'M'};

    public static String putSlat(String key){
        if (key == null){
            return key;
        }else{
            char[] chars = key.toCharArray();
            StringBuffer sf = new StringBuffer();
            String slat = genSlat(8);
            char[] slatArr = slat.toCharArray();
            for (int i = 1; i <= chars.length; i++) {
                sf.append(chars[i - 1]);
                if(i%4 == 0){
                    sf.append(slatArr[i/4 -1]);
                }
            }
            return sf.toString();
        }
    }

    public static String delSlat(String key){
        if (key == null){
            return key;
        }else{
            char[] chars = key.toCharArray();
            StringBuffer sf = new StringBuffer();
            for (int i = 1; i <= chars.length; i++) {
                if(i == 0 || i%5 != 0){
                    sf.append(chars[i-1]);
                }
            }
            return sf.toString();
        }
    }

    public static void main(String[] args) {
        String s = putSlat("1234567890");
        String s2 = delSlat(s);
        System.out.println(s);
        System.out.println(s2);
    }

    private static String genSlat(int len){
        StringBuffer slat = new StringBuffer();
        for (int i = 0; i < len; i++){
            slat.append(SLAT_STR[RandomUtils.nextInt(0, 62)]);
        }
        return slat.toString();
    }
}
