package com.icetech.basics.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author FGD
 */
public class JdbcUtils {
    private static final Pattern PATTERN_MYSQL_JDBC_URL = Pattern.compile("^jdbc:mysql://([\\w.-]+):(\\d+)/(\\w+)(\\?\\S+)?$");

    /**
     * @param jdbcUrl
     * @return
     */
    public static String getHost(String jdbcUrl) {
        Matcher matcher = PATTERN_MYSQL_JDBC_URL.matcher(jdbcUrl);
        if (matcher.find()) {
            return matcher.group(1);
        }

        throw new IllegalArgumentException("invalid mysql jdbc url");
    }
}
