package com.icetech.basics.utils;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class FuzzyPlateTools {

    /**
     * 模糊匹配车牌
     * @param plateNum 完整车牌号
     * @param plot 模糊位数
     * @return
     */
    public static List<String> fuzzyCharacter(String plateNum, int plot){
        if (plot > 2 || plot < 0) {
            return new ArrayList<>();
        }
        List<String> list = new LinkedList<>();
        if (plot + 1 >= plateNum.length()) {
            list.add(plateNum);
            return list;
        }
        String plateNumPart = plateNum.substring(1);
        if (plot == 0){
            list.add("_" + plateNumPart);
            return list;
        }
        int length = plateNumPart.length();

        String prefix = "_";
        final String separator = plot == 1 ? "_" : "__";
        for (int k = 0; k < length - plot + 1; k++){
            int plot2 = plot + k;
            for (int i = k; i < length; i = i +plot){
                if (i == 0) {
                    String replace = separator + plateNumPart.substring(i + plot2, length);
                    list.add(prefix + replace);
                } else if (length - i >= plot){
                    int suffixIndex = i + plot;
                    String replace = plateNumPart.substring(0, i) + separator + (suffixIndex >= length ? "" : plateNumPart.substring(i + plot , length));
                    list.add(replace.startsWith(separator) ? replace : prefix + replace);
                }
            }
        }
        if (plot == 1) {
            list.add(prefix + plateNumPart.substring(0, plateNumPart.length() - 1));
        }
        list = list.stream().distinct().collect(Collectors.toList());
        return list;
    }

    public static void main(String[] args) {
        System.out.println("宁A16E155"+fuzzyCharacter("宁A16E155", 4));
        System.out.println("宁A16E15"+fuzzyCharacter("宁A16E15", 3));
        System.out.println("苏E6D686"+fuzzyCharacter("苏E6D686", 2));
        System.out.println("苏BDM5030"+fuzzyCharacter("苏BDM5030", 1));
    }
}
