package com.icetech.basics.service.device.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.icetech.cloudcenter.api.park.IParkTrusteeshipService;
import com.icetech.park.domain.entity.ParkTrusteeship;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.basics.dao.VipTypeDao;
import com.icetech.basics.dao.device.HeartbeatOfflineDao;
import com.icetech.basics.dao.device.ParkDeviceDao;
import com.icetech.basics.dao.device.ParkDevrecordDao;
import com.icetech.basics.dao.device.ProduceModelDao;
import com.icetech.basics.dao.dictionary.DictionaryItemDao;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.basics.dao.park.ParkInoutdeviceDao;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.device.HeartbeatOffline;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.device.ParkDevrecord;
import com.icetech.basics.domain.entity.device.ProduceModel;
import com.icetech.basics.domain.entity.dictionary.DictionaryItem;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.basics.service.device.ParkDevRecordService;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.basics.service.redis.RedisMsgListener;
import com.icetech.third.utils.RedisUtils;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.device.ParkDeviceInfo;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.park.ParkChannelInfo;
import com.icetech.cloudcenter.domain.park.ParkChannelListPage;
import com.icetech.cloudcenter.domain.park.ParkInoutDeviceInfo;
import com.icetech.cloudcenter.domain.request.DeviceListRequest;
import com.icetech.cloudcenter.domain.request.EzoVideoRequest;
import com.icetech.cloudcenter.domain.request.QueryDeviceRequest;
import com.icetech.cloudcenter.domain.response.DeviceListDTO;
import com.icetech.cloudcenter.domain.response.ParkDeviceDto;
import com.icetech.cloudcenter.domain.vo.InOutYuneasyInfoVo;
import com.icetech.cloudcenter.domain.vo.ParkDeviceVo;
import com.icetech.cloudcenter.domain.websocket.WebsocketPushData;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.constants.RedisKeyConstants;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.*;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.redis.handle.RedisHandle;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.service.third.MqPushService;
import com.icetech.third.service.third.SendInfoServiceImpl;
import com.icetech.user.dao.EnUserDao;
import com.icetech.user.domain.entity.user.EnUser;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.http.util.TextUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.*;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

import static com.icetech.cloudcenter.domain.constants.RedisConstants.PNC_HEARTBEAT_TIME;

/**
 * 设备服务类
 *
 * @author wangzw
 */
@Slf4j
@Service("parkDeviceService")
public class ParkDeviceServiceImpl implements ParkDeviceService {
    @Autowired
    private ParkDeviceDao parkDeviceDao;
    @Autowired
    private ParkDevrecordDao parkDevrecordDao;
    @Autowired
    private ParkDao parkDao;
    @Autowired
    private ParkInoutdeviceDao parkInoutdeviceDao;
    @Autowired
    private EnUserDao enUserDao;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private MqPushService mqPushService;
    @Autowired
    private DictionaryItemDao dictionaryItemDao;
    @Resource
    private RedisHandle redisHandle;
    @Autowired
    private VipTypeDao vipTypeDao;
    @Autowired
    private ParkRegionDao parkRegionDao;

    @Autowired
    private ParkServiceImpl parkService;
    @Resource
    private ProduceModelDao produceModelDao;

    @Autowired
    private HeartbeatOfflineDao heartbeatOfflineDao;
    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    private ParkDevRecordService parkDevRecordService;
    @Autowired
    private HeartbeatOfflineServiceImpl heartbeatOfflineService;
    @Autowired
    private SendInfoServiceImpl sendInfoService;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;

    /**
     * 萤石云 过期时间
     */
    private Integer timeOut = 5;

    //"https://open.ys7.com/ezopen/h5/iframe?url=ezopen://"+parkDevice1.getVerCode()+"@open.ys7.com/"+parkDevice1.getSerialNumber()+"/1.live&autoplay=1&accessToken=";
    private String baseVideoUrl = "https://open.ys7.com/ezopen/h5/iframe?url=ezopen://%s@open.ys7.com/%s/1.live&autoplay=1&accessToken=%s";

    @Override
    public ObjectResponse<List<ParkDeviceDto>> getDeviceByUser(Integer userId, Integer type) {
        List<ParkDeviceDto> list = new ArrayList<>();
        String parkids = parkDao.selectParkOrgByUserId(userId, 2);
        if (parkids == null) {
            return ObjectResponse.success(list);
        }
        List<ParkDevice> parkDevices = parkDeviceDao.selectDeviceListBytype(type);
        for (int i = 0; i < parkDevices.size(); i++) {
            ParkDevice parkDevice = parkDevices.get(i);
            if (checkParkid(parkids, parkDevice.getParkId())) {
                ParkDeviceDto parkDeviceDto = new ParkDeviceDto();
                Park park = parkService.findByParkId(parkDevice.getParkId()).getData();
                parkDeviceDto.setParkName(park.getParkName());
                parkDeviceDto.setDeviceCode(parkDevice.getSerialNumber());
                ObjectResponse<ParkInoutdevice> parkInoutdeviceResp = parkService.getInoutDeviceById(parkDevice.getChannelId().longValue());
                if (!ObjectResponse.isSuccess(parkInoutdeviceResp)) {
                    continue;
                }
                ParkInoutdevice parkInoutdevice = parkInoutdeviceResp.getData();
                if(parkInoutdevice != null){
                    parkDeviceDto.setAisleName(parkInoutdevice.getInandoutName());
                }
                list.add(parkDeviceDto);
            }
        }
        return ObjectResponse.success(list);
    }

    @Override
    public ObjectResponse<List<ParkDevice>> getDeviceByParkChannel(Long parkId, Long channelId) {
        List<ParkDevice> parkDevices = parkDeviceDao.selectDeviceListByParkChannel(parkId, channelId);
        if (parkDevices == null || parkDevices.size() == 0){
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }else{
            return ObjectResponse.success(parkDevices);
        }
    }


    @Override
    public ObjectResponse<ParkDevice> getDeviceByParkIdDevice(Long parkId, String deviceNo) {
        ParkDevice parkDevice = new ParkDevice();
        parkDevice.setParkId(parkId);
        parkDevice.setDeviceNo(deviceNo);
        ParkDevice parkDeviceRet = parkDeviceDao.selectByParam(parkDevice);
        if (parkDeviceRet != null){
            return ObjectResponse.success(parkDeviceRet);
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<ParkDevice> getDeviceBySerialNumber(String serialNumber) {
        ParkDevice parkDeviceRet = cacheDeviceBySerialNumber(serialNumber);
        if (parkDeviceRet != null) {
            return ObjectResponse.success(parkDeviceRet);
        } else {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    public ParkDevice cacheDeviceBySerialNumber(String serialNumber) {
        String cacheKye = RedisKeyConstants.KEY_PREFIX_PARK_DEVICE_SERIAL_NUMBER + serialNumber;
        return redisHandle.cacheObject(cacheKye, ParkDevice.class, () -> {
            ParkDevice param = new ParkDevice();
            param.setSerialNumber(serialNumber);
            return parkDeviceDao.selectByParam(param);
        }, RedisKeyConstants.EXPIRE_PARK_DEVICE);
    }

    @Override
    public ObjectResponse<List<ParkDevice>> getDeviceByChannel(Long parkId, String channelCode, Integer type) {
        List<ParkDevice> parkDevices = parkDeviceDao.selectDeviceListByChannel(parkId, channelCode, type);
        if (parkDevices != null && parkDevices.size() > 0){
            return ObjectResponse.success(parkDevices);
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse addDevice(ParkDevice parkDevice) {
        int insert = parkDeviceDao.insert(parkDevice);
        if (insert > 0){
            return ObjectResponse.success();
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR);
        }
    }

    @Override
    public ObjectResponse updateDevice(ParkDevice parkDevice) {
        parkDevice.setDelFlag(null);
        int update = parkDeviceDao.updateById(parkDevice);
        if (update > 0){
            String cacheKye = RedisKeyConstants.KEY_PREFIX_PARK_DEVICE_SERIAL_NUMBER + parkDevice.getSerialNumber();
            redisTemplate.delete(cacheKye);
            return ObjectResponse.success();
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR);
        }
    }

    @Override
    public ObjectResponse<ParkDevice> selectById(ParkDevice parkDevice) {
        ParkDevice device = parkDeviceDao.selectByParam(parkDevice);
        if (Objects.isNull(device)){
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }else {
            return ObjectResponse.success(device);
        }
    }

    @Override
    public ObjectResponse<List<ParkDevice>> getDevicesByParkChannel(Long parkId, Long[] channelIds, Integer type) {
        List<ParkDevice> parkDevices = parkDeviceDao.selectDevicesByParkChannel(parkId, Arrays.asList(channelIds), type);
        if (parkDevices.size() > 0){
            return ObjectResponse.success(parkDevices);
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<Page<DeviceListDTO>> upgradeDeviceList(DeviceListRequest deviceListRequest) {
        if (deviceListRequest == null){
            deviceListRequest = new DeviceListRequest();
        }
        String productModel = null;
        if (deviceListRequest.getProductModelId() != null){
            DictionaryItem dictionaryItem = dictionaryItemDao.selectOneItem(8, null, deviceListRequest.getProductModelId());
            if (dictionaryItem == null){
                return ObjectResponse.failed(CodeConstants.ERROR_404, "设备型号不存在");
            }else{
                productModel = dictionaryItem.getText();
            }
        }
        PageHelper.startPage(deviceListRequest.getPageNo(),deviceListRequest.getPageSize());
        List<DeviceListDTO> deviceListRespons = parkDeviceDao.selectUpgradeList(deviceListRequest.getParkIdList(), deviceListRequest.getDeviceType(), deviceListRequest.getDeviceStatus(), productModel, deviceListRequest.getSn());
        if (CollectionUtil.isEmpty(deviceListRespons)){
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        PageInfo pageInfo = new PageInfo(deviceListRespons);
        Page<DeviceListDTO> page = new Page<>();
        page.setRows(deviceListRespons);
        page.setTotal(pageInfo.getTotal());
        page.setTotalPage(pageInfo.getPages());

        return ObjectResponse.success(page);
    }

    @Override
    public ObjectResponse<List<ProduceModel>> getProduceModelList() {
        List<ProduceModel> produceModels = redisHandle.cacheList(RedisKeyConstants.KEY_PREFIX_PRODUCE_MODEL,
                ProduceModel.class, () -> produceModelDao.selectList(Wrappers.emptyWrapper()),
                RedisKeyConstants.EXPIRE_PRODUCE_MODEL);
        return ObjectResponse.success(produceModels);
    }

    @Override
    public ParkDevice getDeviceByParkIdAndChannelId(Long parkId, Long channelId) {
        return parkDeviceDao.selectDeviceByAisleCode(parkId,channelId);
    }

    @Override
    public ObjectResponse deviceStatusUpdate(String serialNumber, Long eventTime,
                                             Integer status, Integer deviceType) {
        ObjectResponse<ParkDevice> deviceObjectResponse = getDeviceBySerialNumber(serialNumber);
        if (!ObjectResponse.isSuccess(deviceObjectResponse)
                || !deviceObjectResponse.getData().getType().equals(deviceType)){
            log.warn("[设备状态变化] serialNumber[{}], 设备不存在", serialNumber);
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        ParkDevice parkDevice = deviceObjectResponse.getData();
        int currStatus = parkDevice.getStatus();
        if (status == 2 && currStatus != 2) {
            //更新设备的连接状态为：在线
            modifyStatus(parkDevice.getParkId(), parkDevice.getDeviceNo(),
                    2, "下线", DateTools.unixTimestamp());
            //增加掉线记录
            HeartbeatOffline heartbeatOffline = new HeartbeatOffline();
            heartbeatOffline.setParkId(parkDevice.getParkId());
            String key = null;
            if (deviceType == 1) {
                key = RedisConstants.P2C_HEARTBEAT_TIME;
            } else if (deviceType == 5) {
                key = RedisConstants.P2R_HEARTBEAT_TIME;
            } else if (deviceType == 8) {
                key = RedisConstants.ITC_HEARTBEAT_TIME;
            } else if (deviceType == 9) {
                key = RedisConstants.MOR_HEARTBEAT_TIME;
            }
            if (key != null) {
                Long lastHeartbeatTime = eventTime != null ? eventTime : redisUtils.hGet(key, serialNumber, Long.class);
                heartbeatOffline.setLastConnectionTime(lastHeartbeatTime == null
                        ? DateTools.unixTimestamp() : lastHeartbeatTime);
                heartbeatOffline.setDeviceNo(parkDevice.getDeviceNo());
                heartbeatOfflineDao.insert(heartbeatOffline);
            }
        }
        if (status == 1 && currStatus != 1) {
            //更新设备的连接状态为：在线
            modifyStatus(parkDevice.getParkId(), parkDevice.getDeviceNo(),
                    1, null, null);
            // 添加车场连接断开记录表
            HeartbeatOffline ret = heartbeatOfflineDao.selectLast(parkDevice.getParkId(), parkDevice.getDeviceNo());
            if (ret != null) {
                ret.setReconnectTime(eventTime);
                ret.setOffTime(eventTime - ret.getLastConnectionTime());
                heartbeatOfflineDao.updateById(ret);
            }
        }
        return ObjectResponse.success();
    }

    /**
     * 验证设备是否属于当前用户车场
     * @param parkids
     * @param parkid
     * @return
     */
    private boolean checkParkid(String parkids,long parkid){
        String[] userpark = parkids.split(",");
        for (int i = 0; i < userpark.length; i++) {
            int integer = Integer.parseInt(userpark[i]);
            if(integer == parkid){
                return true;
            }
        }
        return false;
    }

    @Override
    public ObjectResponse operation(String deviceCode, Long parkId) {
        try {
            boolean isDelete = false;
            ParkDevice parkDevice = new ParkDevice();
            parkDevice.setDeviceNo(deviceCode);
            parkDevice.setParkId(parkId);
            ParkDevice parkDevice1 = parkDeviceDao.selectByParam(parkDevice);
            if(Objects.isNull(parkDevice1)){
                ParkDevice parkDevice2 = parkDeviceDao.selectDeleteById(parkDevice);
                if(!Objects.isNull(parkDevice2)){
                    parkDevice1 = parkDevice2;
                    isDelete = true;
                }
            }
            String cacheKye = RedisKeyConstants.KEY_PREFIX_PARK_DEVICE_SERIAL_NUMBER + parkDevice1.getSerialNumber();

            EnUser enUser = enUserDao.selectById(parkDevice1.getEzopenId());
            if(Objects.isNull(enUser)){
                return ObjectResponse.failed(CodeConstants.ERROR_404,"账户错误");
            }
            String getTokenBaseUrl = "https://open.ys7.com/api/lapp/token/get?";
            String getDeviceBaseUrl = "https://open.ys7.com/api/lapp/device/info?";
            String addDeviceBaseUrl = "https://open.ys7.com/api/lapp/device/add?";
            String delTokenBaseUrl = "https://open.ys7.com/api/lapp/device/delete?";
            String offDeviceBaseUrl = "https://open.ys7.com/api/lapp/device/encrypt/off?";
            String enUrl = "https://open.ys7.com/ezopen/h5/iframe?url=ezopen://"+parkDevice1.getVerCode()+"@open.ys7.com/"+parkDevice1.getSerialNumber()+"/1.live&autoplay=1&accessToken=";
            String tokenRes = HttpTools.post(getTokenBaseUrl +
                    "appKey=" + enUser.getAppKey() +
                    "&appSecret=" + enUser.getSecret());
            String accessToken;
            Map tmap = (Map) JSON.parse(tokenRes);
            if("200".equals(tmap.get("code"))){
                String data = tmap.get("data").toString();
                Map map = (Map) JSON.parse(data);
                accessToken = map.get("accessToken").toString();
                log.info("获取到taoken：{}",accessToken);
                if(isDelete){
                    String post = HttpTools.post(delTokenBaseUrl +
                            "accessToken=" + accessToken +
                            "&deviceSerial=" + parkDevice1.getSerialNumber());
                    log.info("[监控相机删除成功，设备序列号：] [{}]",parkDevice1.getSerialNumber());

                    return ObjectResponse.success();
                }
                String deviceRes = HttpTools.post(getDeviceBaseUrl +
                        "accessToken=" + accessToken +
                        "&deviceSerial=" + parkDevice1.getSerialNumber());
                Map dmap = (Map) JSON.parse(deviceRes);
                if("200".equals(dmap.get("code"))){
                    String data1 = dmap.get("data").toString();
                    Map dsmap = (Map) JSON.parse(data1);
                    parkDevice1.setStatus(1);
                    if(Integer.parseInt(dsmap.get("status").toString())== 0){
                        parkDevice1.setStatus(2);
                    }
                    if(Integer.parseInt(dsmap.get("isEncrypt").toString()) == 1){
                        String off = HttpTools.post(offDeviceBaseUrl +
                                "accessToken=" + accessToken +
                                "&deviceSerial=" + parkDevice1.getSerialNumber() +
                                "&validateCode=" + parkDevice1.getVerCode());
                        Map omap = (Map) JSON.parse(off);
                        if("20010".equals(omap.get("code"))){
                            log.info("请求萤石结果[{}], sn[{}]", off, parkDevice1.getSerialNumber());
                            ParkDevrecord parkDevrecord = new ParkDevrecord();
                            parkDevrecord.setDeviceId(parkDevice1.getId());
                            parkDevrecord.setStatus(3);
                            parkDevrecord.setWrongTime(new Date());
                            parkDevrecord.setReason(omap.get("msg").toString());
                            parkDevrecordDao.insert(parkDevrecord);
                            parkDevice1.setStatus(2);
                            parkDevice1.setEndUpdatetime(new Date());
                        }
                    }
                    enUrl = enUrl + accessToken;
                    parkDevice1.setVideoUrl(enUrl);
                    final ParkDevice parkDevice2 = parkDevice1;
                    asyncExecutor.execute(ThreadUtils.wrapTrace(() -> parkDeviceDao.updateById(parkDevice2)));
                    redisTemplate.delete(cacheKye);
                    log.info("[监控相机更新成功]，设备序列号[{}]，播放地址已更新[{}]",parkDevice1.getSerialNumber(),parkDevice1.getVideoUrl());
                    return ObjectResponse.success();
                }else{//添加
                    String addRes = HttpTools.post(addDeviceBaseUrl +
                            "accessToken=" + accessToken +
                            "&deviceSerial=" + parkDevice1.getSerialNumber() +
                            "&validateCode=" + parkDevice1.getVerCode());
                    Map amap = (Map) JSON.parse(addRes);
                    if("200".equals(amap.get("code"))){
                        parkDevice1.setStatus(1);
                        parkDevice1.setEndUpdatetime(new Date());
                        log.info("[监控相机添加成功] 设备序列号[{}]，播放地址已更新[{}]",parkDevice1.getSerialNumber(),parkDevice1.getVideoUrl());
                    }else{
                        ParkDevrecord parkDevrecord = new ParkDevrecord();
                        parkDevrecord.setDeviceId(parkDevice1.getId());
                        parkDevrecord.setStatus(2);
                        parkDevrecord.setWrongTime(new Date());
                        parkDevrecord.setReason(amap.get("msg").toString());
                        parkDevrecordDao.insert(parkDevrecord);
                        parkDevice1.setStatus(2);
                        parkDevice1.setEndUpdatetime(new Date());
                        log.info("[监控相机添加失败] 设备序列号[{}]，失败原因[{}]",parkDevice1.getSerialNumber(),amap.get("msg"));
                        //return ObjectResponse.failed(CodeConstants.ERROR,amap.get("msg"));
                    }
                    enUrl = enUrl + accessToken;
                    parkDevice1.setVideoUrl(enUrl);
                    final ParkDevice parkDevice2 = parkDevice1;
                    asyncExecutor.execute(ThreadUtils.wrapTrace(() -> parkDeviceDao.updateById(parkDevice2)));
                    redisTemplate.delete(cacheKye);
                }
            }else{
                ParkDevrecord parkDevrecord = new ParkDevrecord();
                parkDevrecord.setDeviceId(parkDevice1.getId());
                parkDevrecord.setStatus(2);
                parkDevrecord.setWrongTime(new Date());
                parkDevrecord.setReason("获取账户TOKEN失败");
                parkDevrecordDao.insert(parkDevrecord);
                return ObjectResponse.failed(CodeConstants.ERROR,"获取账户TOKEN失败");
            }
        }catch (Exception e) {
            log.error("操作失败: {}. deviceCode[{}], parkId[{}]", e.getMessage(), deviceCode, parkId, e);
        }
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<InOutYuneasyInfoVo> getInOutYuneasyInfoVo(Long parkId, String aisleCode) {
        List<Integer> deviceType = new ArrayList<>();
        deviceType.add(1);
        deviceType.add(4);
        deviceType.add(6);
        List<String> aisleCodes = new ArrayList<>();
        aisleCodes.add(aisleCode);
        List<ParkDevice> parkDevices = parkDeviceDao.selectDeviceList(parkId, aisleCodes, null, deviceType);
        if (CollectionUtils.isEmpty(parkDevices)) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        InOutYuneasyInfoVo inOutYuneasyInfoVo = new InOutYuneasyInfoVo();
        parkDevices.forEach(t-> {
            if (t.getType() == 1) {
                inOutYuneasyInfoVo.setSerialNumber(t.getSerialNumber());
            }
            if (t.getType() == 4 && Objects.nonNull(t.getVoicevendorType()) && t.getVoicevendorType() == 1) {
                inOutYuneasyInfoVo.setYuneasyNumber(t.getSerialNumber());
            }
        });
        return ObjectResponse.success(inOutYuneasyInfoVo);
    }

    @Override
    public ObjectResponse enDeviceStatus() {
        List<ParkDevice> parkDevices = parkDeviceDao.selectDeviceListBytype(6);
        if (parkDevices.size() == 0) {
            return ObjectResponse.success();
        }

        String getDeviceBaseUrl = "https://open.ys7.com/api/lapp/device/info?";
        for (ParkDevice parkDevice : parkDevices) {
            if (Objects.isNull(parkDevice.getEzopenId())) {
                continue;
            }
            EnUser enUser = enUserDao.selectById(parkDevice.getEzopenId());
            if (Objects.isNull(enUser)) {
                continue;
            }
            String redisKey = RedisConstants.PREFIX_YSY_TOKEN + parkDevice.getParkId() + ":" + parkDevice.getDeviceNo();
            String accessToken = redisTemplate.opsForValue().get(redisKey);
            log.info("token 内容 [{}]", accessToken);
            if (!TextUtils.isEmpty(accessToken)) {
                String videoUrl = parkDevice.getVideoUrl();
                if (videoUrl.contains("accessToken")) {
                    if (!parkDevice.getVideoUrl().contains(accessToken)) {
                        parkDevice.setVideoUrl(videoUrl.substring(0, videoUrl.indexOf("accessToken=")) + "accessToken=" + accessToken);
                    }
                } else {
                    continue;
                }
                String deviceRes = HttpTools.post(getDeviceBaseUrl +
                        "accessToken=" + accessToken +
                        "&deviceSerial=" + parkDevice.getSerialNumber());
                log.info("更新萤石云设备状态 [{}]", deviceRes);
                Map dmap = (Map) JSON.parse(deviceRes);
                if ("200".equals(dmap.get("code"))) {
                    String data1 = dmap.get("data").toString();
                    Map dsmap = (Map) JSON.parse(data1);
                    //int status = new Random(2).nextInt();
                    modifyStatus(parkDevice.getParkId(), parkDevice.getDeviceNo(),
                            (Integer.parseInt(dsmap.get("status").toString()) == 1) ? 1 : 2,
                            (Integer.parseInt(dsmap.get("status").toString()) == 1) ?
                                    "萤石在线" : "萤石离线", System.currentTimeMillis() / 1000);
                } else {
                    String msg = String.valueOf(dmap.get("msg"));
                    if (msg != null && (msg.contains("Data error") || msg.contains("服务器错误"))) {
                        return ObjectResponse.success();
                    }
                    modifyStatus(parkDevice.getParkId(), parkDevice.getDeviceNo(), 2,
                            msg, System.currentTimeMillis() / 1000);
                }
            } else {
                asyncExecutor.execute(ThreadUtils.wrapTrace(() -> updateConsoleTokenForRedis(parkDevice)));
            }
        }
        return ObjectResponse.success();
    }

    /**
     * 更新萤石云token 并更新到 redis上
     * @return
     */
    @Override
    public ObjectResponse<String> updateConsoleTokenForRedis(ParkDevice parkDeviceFind) {

        if(Objects.isNull(parkDeviceFind)){
            return ObjectResponse.failed(CodeConstants.ERROR_404,"未找到设备");
        }
        log.info("updateConsoleTokenForRedis  >  {},{},{}",parkDeviceFind.getDeviceNo(),parkDeviceFind.getParkId(),parkDeviceFind.getVerCode());
        if (TextUtils.isEmpty(parkDeviceFind.getVerCode())){
            return ObjectResponse.failed(CodeConstants.ERROR_400,"VerCode 为空");
        }
        EnUser enUser = enUserDao.selectById(parkDeviceFind.getEzopenId());
        if(Objects.isNull(enUser)){
            return ObjectResponse.failed(CodeConstants.ERROR_404,"账户错误");
        }
        String getTokenBaseUrl = "https://open.ys7.com/api/lapp/token/get?";
        String tokenRes = HttpTools.post(getTokenBaseUrl +
                "appKey=" + enUser.getAppKey() +
                "&appSecret=" + enUser.getSecret());
        String accessToken = "";
        log.info("updateConsoleTokenForRedis  >  {}",tokenRes);
        Map tmap = (Map) JSON.parse(tokenRes);
        if("200".equals(tmap.get("code"))) {
            String data = tmap.get("data").toString();
            Map map = (Map) JSON.parse(data);
            accessToken = map.get("accessToken").toString();
            log.info("获取到token：{}", accessToken);
            String tokenKey = RedisConstants.PREFIX_YSY_TOKEN + parkDeviceFind.getParkId() + ":" + parkDeviceFind.getDeviceNo();
            redisTemplate.opsForValue().set(tokenKey,accessToken,timeOut, TimeUnit.DAYS);
            String oldVideoUrl = parkDeviceFind.getVideoUrl();
            if (TextUtils.isEmpty(oldVideoUrl)){
                parkDeviceFind.setVideoUrl(String.format(baseVideoUrl,parkDeviceFind.getVerCode(),parkDeviceFind.getSerialNumber(),accessToken));
            }else {
                parkDeviceFind.setVideoUrl(oldVideoUrl.substring(0, oldVideoUrl.indexOf("accessToken=")) + "accessToken=" + accessToken);
            }
            parkDeviceDao.updateById(parkDeviceFind);
            String cacheKye = RedisKeyConstants.KEY_PREFIX_PARK_DEVICE_SERIAL_NUMBER + parkDeviceFind.getSerialNumber();
            redisTemplate.delete(cacheKye);
            return ObjectResponse.success(accessToken);
        }
        return ObjectResponse.failed("token 更新失败");
    }

    @Override
    public ObjectResponse updateAccessToken(List<Map<String, String>> maps) {
        String baseurl = "https://open.ys7.com/api/lapp/token/get?";
        try {
            List<ParkDevice> parkDevices = parkDeviceDao.selectDeviceListBytype(6);
            if(parkDevices.size() == 0){
                log.info("没有监控相机");
                return ObjectResponse.success();
            }
            List<EzoVideoRequest> list = convertListMap2ListBean(maps, EzoVideoRequest.class);
            for (int i = 0; i < list.size(); i++) {
                EzoVideoRequest ezoVideoRequest = list.get(i);
                String post = HttpTools.post(baseurl +
                        "appKey=" + ezoVideoRequest.getAppKey() +
                        "&appSecret=" + ezoVideoRequest.getSecret());
                log.info("请求地址{},返回{}",baseurl +
                        "appKey=" + ezoVideoRequest.getAppKey() +
                        "&appSecret=" + ezoVideoRequest.getSecret(),post);
                String accessToken = "";
                Map map1 = (Map) JSON.parse(post);
                if("200".equals(map1.get("code"))){
                    String data = map1.get("data").toString();
                    Map map = (Map) JSON.parse(data);
                    accessToken = map.get("accessToken").toString();
                    if(isTokenTimeOut(parkDevices,accessToken)){
                        updateToken(parkDevices,ezoVideoRequest,accessToken);
                    }
                }
            }
        } catch (Exception e) {
            log.error("更新萤石云token异常: {}. maps[{}]", e.getMessage(), maps, e);
        }

        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse reportDeviceStatus(String deviceNo, Integer deviceType, Integer state) {
        if(StringUtils.isEmpty(deviceNo)){
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_400);
        }
        List<ParkDevice> parkDevices = parkDeviceDao.selectWayDetailByvid(deviceNo);
        for (int i = 0; i < parkDevices.size(); i++) {
            ParkDevice parkDevice = parkDevices.get(i);
            modifyStatus(parkDevice.getParkId(), parkDevice.getDeviceNo(),
                    state,"",System.currentTimeMillis()/1000);
        }

        return ObjectResponse.success();
    }

    @Override
    public List<ParkDevice> getDeviceListByParkId(Long parkId) {
        return parkDeviceDao.selectList(Wrappers.lambdaQuery(ParkDevice.class).eq(ParkDevice::getParkId, parkId).eq(ParkDevice::getDelFlag, 0));
    }

    @Override
    public ObjectResponse<List<ParkDevice>> getDeviceListByParkIdAndType(Long parkId, Integer type) {
        List<ParkDevice> parkDevices = parkDeviceDao.selectDeviceListByParkIdAndType(parkId,type);
        if (CollectionUtils.isEmpty(parkDevices)) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(parkDevices);
    }

    @Override
    public ObjectResponse<List<ParkDevice>> getDeviceListByChannelId(Long channelId, Integer type) {
        if (channelId == null) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        List<ParkDevice> parkDevices = parkDeviceDao.selectDeviceListByChannelId(channelId,type);
        if (CollectionUtils.isEmpty(parkDevices)) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(parkDevices);
    }

    @Override
    public ObjectResponse<List<ParkDevice>> getDeviceListByChannelIds(List<Long> channelIds, Integer type) {
        if (CollectionUtils.isEmpty(channelIds)) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        List<ParkDevice> parkDevices = parkDeviceDao.selectDeviceListByChannelIds(channelIds,type);
        if (CollectionUtils.isEmpty(parkDevices)) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(parkDevices);
    }

    @Override
    public ObjectResponse<List<ParkDevice>> getDeviceListByParkChannelId(Long parkId, Integer channelId, int deviceType) {
        List<ParkDevice> parkDevices = parkDeviceDao.selectDeviceListByParkIdAndChannelId(parkId, channelId, deviceType);
        if (parkDevices != null && parkDevices.size() > 0){
            return ObjectResponse.success(parkDevices);
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<List<ParkDevice>> getDeviceListByParkRegionId(Long parkId, Integer regionId, int deviceType) {
        List<ParkDevice> parkDevices = parkDeviceDao.selectDeviceListByParkIdAndRegionId(parkId, regionId, deviceType);
        if (parkDevices != null && parkDevices.size() > 0){
            return ObjectResponse.success(parkDevices);
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    /**
     * 更新设备token
     * @param ezoVideoRequest
     * @param accessToken
     */
    private void updateToken(List<ParkDevice> parkDevices,EzoVideoRequest ezoVideoRequest,String accessToken){
        String[] split = ezoVideoRequest.getCamera().split(",");
        for (int i = 0; i < split.length; i++) {
            for (int j = 0; j < parkDevices.size(); j++) {
                ParkDevice device = parkDevices.get(j);
                if(split[i].equals(device.getSerialNumber())){
                    String videoUrl = device.getVideoUrl();
                    if(videoUrl.contains("accessToken")){
                        device.setVideoUrl(videoUrl.substring(0, videoUrl.indexOf("accessToken="))+"accessToken="+accessToken);
                        parkDeviceDao.updateById(device);
                        String cacheKye = RedisKeyConstants.KEY_PREFIX_PARK_DEVICE_SERIAL_NUMBER + device.getSerialNumber();
                        redisTemplate.delete(cacheKye);
                        log.info("设备序列号{}已更新token{},原地址{},",split[i],accessToken,videoUrl);
                    }
                }
            }
        }
    }

    /**
     * 根据序列号获取相机信息
     * @param parkDevices
     * @param serialNumber
     * @return
     */
    private ParkDevice getDevice(List<ParkDevice> parkDevices,String serialNumber){
        for (int i = 0; i < parkDevices.size(); i++) {
            ParkDevice parkDevice = parkDevices.get(i);
            if(serialNumber.equals(parkDevice.getSerialNumber())){
                return parkDevice;
            }
        }
        return null;
    }
    /**
     * 判断token是否过期
     * @param parkDevices
     * @param token
     * @return
     */
    private boolean isTokenTimeOut(List<ParkDevice> parkDevices,String token){
        boolean key = true;
        for (int j = 0; j < parkDevices.size(); j++) {
            ParkDevice parkDevice = parkDevices.get(j);
            String videoUrl = parkDevice.getVideoUrl();
            if(!StringUtils.isEmpty(videoUrl)){
                if(videoUrl.contains(token)){
                    key = false;
                    break;
                }
            }
        }
        return key;
    }

    @Override
    @DS_SLAVE
    public ObjectResponse<Map<String, Object>> countDeviceAlarmList(QueryDeviceRequest queryDeviceRequest) {
        try {
            String[] split = queryDeviceRequest.getParkCode().split(",");
            String parkid = parkDao.selectByCodes(split);
            if (parkid != null && parkid.endsWith(",")) {
                parkid = parkid.substring(0, parkid.length() - 1);
            }
            int count = parkDevrecordDao.countDeviceAlarmList(parkid, queryDeviceRequest.getDeviceNo(),
                    Objects.isNull(queryDeviceRequest.getStartTime()) ? null : DateTools.getFormat(queryDeviceRequest.getStartTime()), Objects.isNull(queryDeviceRequest.getEndTime()) ? null : DateTools.getFormat(queryDeviceRequest.getEndTime()),
                    queryDeviceRequest.getDeviceType());
            Map<String, Object> map = new HashMap<>();
            map.put("count", count);
            return ObjectResponse.success(map);
        } catch (Exception e) {
            log.error("[获取设备报警信息]接口异常: {}. queryDeviceRequest[{}]", e.getMessage(), queryDeviceRequest, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    @DS_SLAVE
    public ObjectResponse<List<ParkDevrecord>> getDeviceAlarmList(QueryDeviceRequest queryDeviceRequest) {
        List<ParkDevrecord> parkDevrecords = new ArrayList<ParkDevrecord>();
        try {
            if(StringUtils.isBlank(queryDeviceRequest.getParkCode())) {
                return ObjectResponse.failed(CodeConstants.ERROR_404);
            }
            String[] split = queryDeviceRequest.getParkCode().split(",");
            String parkid = parkDao.selectByCodes(split);
            PageHelper.startPage(queryDeviceRequest.getPageNo(), queryDeviceRequest.getPageSize());
            parkDevrecords = parkDevrecordDao.selectDeviceAlarmList(parkid, queryDeviceRequest.getDeviceNo(),
                    Objects.isNull(queryDeviceRequest.getStartTime()) ? null : DateTools.getFormat(queryDeviceRequest.getStartTime()), Objects.isNull(queryDeviceRequest.getEndTime()) ? null : DateTools.getFormat(queryDeviceRequest.getEndTime()),
                    queryDeviceRequest.getDeviceType());
        } catch (Exception e) {
            log.error("[获取设备报警信息]接口异常: {}. queryDeviceRequest[{}]", e.getMessage(), queryDeviceRequest, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
        return ObjectResponse.success(parkDevrecords);
    }

    @SentinelResource(value = "ParkDevice.getDeviceList", fallback = "handleFallback")
    @Override
    public ObjectResponse<List<ParkDeviceDto>> getDeviceList(QueryDeviceRequest queryDeviceRequest) {
        try {
            Park park = parkService.findByParkCode(queryDeviceRequest.getParkCode()).getData();
            PageHelper.startPage(queryDeviceRequest.getPageNo(), queryDeviceRequest.getPageSize());
            List<ParkDevice> parkDevices = parkDeviceDao.selectDeviceList(park.getId(), queryDeviceRequest.getAisleCode(),
                    queryDeviceRequest.getStatus(), queryDeviceRequest.getDeviceType());

            if (CollectionUtils.isEmpty(parkDevices)) {
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
            }
            List<ParkDeviceDto> deviceDtos = Lists.newArrayList();
            //设置原因
            parkDevices.forEach(parkDevice -> {
                ParkDeviceDto parkDeviceDto = new ParkDeviceDto();
                parkDeviceDto.setId(parkDevice.getId());
                parkDeviceDto.setDeviceCode(parkDevice.getDeviceNo());
                parkDeviceDto.setDeviceType(parkDevice.getType());
                parkDeviceDto.setStatus(parkDevice.getStatus());
                ParkInoutdevice parkInoutdevice = parkService.getInoutDeviceById(parkDevice.getChannelId().longValue()).getData();
                if (Objects.nonNull(parkInoutdevice)){
                    //设置通道名称
                    parkDeviceDto.setAisleName(parkInoutdevice.getInandoutName());
                    parkDeviceDto.setAisleCode(parkInoutdevice.getInandoutCode());
                }
                if (parkDevice.getStatus() == 3) {
                    //设置故障原因
                    parkDeviceDto.setReason(parkDeviceDao.getDeviceReason(parkDevice.getId()));
                }
                parkDeviceDto.setUpdateTime(parkDevice.getUpdateTime());
                deviceDtos.add(parkDeviceDto);
            });
            return ObjectResponse.success(deviceDtos);
        } catch (Exception e) {
            log.error("操作失败: {}. queryDeviceRequest[{}]", e.getMessage(), queryDeviceRequest, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    public ObjectResponse<List<ParkDeviceDto>> handleFallback(QueryDeviceRequest queryDeviceRequest){
        return new ObjectResponse("200", "服务降级返回");
    }
    @Override
    public ObjectResponse<List<ParkDevice>> getDeviceListByType(Long parkId, int type) {
        List<ParkDevice> parkDevices = parkDeviceDao.selectDeviceListByParkIdAndType(parkId, type);
        if (parkDevices != null && parkDevices.size() > 0){
            return ObjectResponse.success(parkDevices);
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<Boolean> isAllOnline(Long parkId, int type, int dataCollection) {
        if (dataCollection == 2) {
            Long heartbeatTime = redisUtils.hGet(PNC_HEARTBEAT_TIME, parkId.toString(), Long.class);
            if (heartbeatTime == null || heartbeatTime < DateTools.unixTimestamp() - 70) {
                return ObjectResponse.failed(CodeConstants.ERROR_404);
            } else {
                return ObjectResponse.success(true);
            }
        }
        ObjectResponse<List<ParkDevice>> deviceListByType = getDeviceListByType(parkId, type);
        if (CollectionUtils.isNotEmpty(deviceListByType.getData())) {
            return ObjectResponse.success(deviceListByType.getData().stream().noneMatch(device -> device.getStatus() != 1));
        } else {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<ParkDeviceDto> getDeviceDetail(String parkCode, Integer recordId) {
        try {
            //获取设备信息
            ParkDevice parkDevice = parkDeviceDao.load(recordId);
            ParkDeviceDto parkDeviceDto = new ParkDeviceDto();
            parkDeviceDto.setId(parkDevice.getId());
            parkDeviceDto.setDeviceCode(parkDevice.getDeviceNo());
            parkDeviceDto.setDeviceType(parkDevice.getType());
            parkDeviceDto.setStatus(parkDevice.getStatus());
            //设置通道名称
            parkDeviceDto.setAisleName(parkInoutdeviceDao.selectChannelName(parkDevice.getChannelId()));
            if (parkDevice.getStatus() == 3) {
                //设置故障原因
                parkDeviceDto.setReason(parkDeviceDao.getDeviceReason(parkDevice.getId()));
            }
            parkDeviceDto.setUpdateTime(parkDevice.getUpdateTime());
            return ObjectResponse.success(parkDeviceDto);
        } catch (Exception e) {
            log.error("[车场管家获取设备详情+接口异常] [{}][{}]",parkCode,recordId, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    public ObjectResponse<Void> modifyStatus(Long parkId, String deviceNo, Integer status, String reason, Long wrongTime) {
        ParkDevice parkDevice_para = new ParkDevice();
        parkDevice_para.setParkId(parkId);
        parkDevice_para.setDeviceNo(deviceNo);
        ParkDevice parkDevice_result = parkDeviceDao.selectByParam(parkDevice_para);
        log.info("modifyStatus => {}", parkDevice_result);
        if (parkDevice_result != null) {
            Integer oldStatus = parkDevice_result.getStatus();
            Date endUpdatetime = null;
            if (status == 1 || (status == 2 && !status.equals(oldStatus))) {
                if (status == 1) {
                    //在线状态时，更新最后连接时间
                    endUpdatetime = new Date();
                    parkDevice_result.setEndUpdatetime(endUpdatetime);
                }
                parkDevice_result.setStatus(status);
                parkDeviceDao.updateStatus(parkId, deviceNo, status, endUpdatetime);
            }
            if (!status.equals(oldStatus)) {
                if (status != 1) //要更新成离线，且与上次状态不相同，才会写入报警记录
                    parkDevrecordDao.insert(getInsertPara(status, reason, wrongTime, parkDevice_result.getId()));
                // 推送给坐席,需要前端更新状态配置
                deviceStatusSync(status, parkDevice_result);
            }
            return ObjectResponse.success();
        } else {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    private void deviceStatusSync(Integer status, ParkDevice parkDevice) {
        String cacheKye = RedisKeyConstants.KEY_PREFIX_PARK_DEVICE_SERIAL_NUMBER + parkDevice.getSerialNumber();
        redisTemplate.delete(cacheKye);
        asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            pushDeviceStatus(parkDevice.getParkId(), status, Long.valueOf(parkDevice.getChannelId()), parkDevice.getType());
            mqPushService.pushDeviceStatus(parkDevice);
        }));
    }

    public void batchModifyStatus(List<String> snList, Map<String, Long> snHeartbeatMap,
                                  Integer deviceType, Integer status) {
        if (snList == null || snList.isEmpty()) {
            return;
        }
        //离线
        if (status == 2) {
            //查询离线设备，找到状态为在线的集合，批量更新设备状态
            parkDeviceDao.batchUpdateStatus(snList, deviceType, 1, 2);
            List<ParkDevrecord> parkDevrecordList = new ArrayList<>();
            List<ParkDevice> parkDevices = parkDeviceDao.selectListBySns(snList, deviceType);
            //同步设备状态变化
            parkDevices.forEach(parkDevice -> deviceStatusSync(status, parkDevice));
            List<HeartbeatOffline> offlineList = parkDevices.stream()
                    .map(parkDevice -> {
                        //增加掉线记录
                        HeartbeatOffline heartbeatOffline = new HeartbeatOffline();
                        heartbeatOffline.setParkId(parkDevice.getParkId());
                        heartbeatOffline.setLastConnectionTime(snHeartbeatMap.get(parkDevice.getSerialNumber()));
                        heartbeatOffline.setDeviceNo(parkDevice.getDeviceNo());

                        //要更新成离线，且与上次状态不相同，才会写入报警记录
                        ParkDevrecord parkDevrecord = new ParkDevrecord();
                        parkDevrecord.setDeviceId(parkDevice.getId());
                        parkDevrecord.setStatus(2);
                        parkDevrecord.setReason("下线");
                        parkDevrecord.setWrongTime(new Date(heartbeatOffline.getLastConnectionTime() * 1000));
                        parkDevrecordList.add(parkDevrecord);

                        return heartbeatOffline;
                    }).collect(Collectors.toList());
            heartbeatOfflineService.saveBatch(offlineList);
            parkDevRecordService.saveBatch(parkDevrecordList);
        }
        if (status == 1) {
            //查询在线设备，找到状态为离线的集合，批量更新设备状态
            parkDeviceDao.batchUpdateStatus(snList, deviceType, 2, 1);
            List<ParkDevice> parkDevices2 = parkDeviceDao.selectListBySns(snList, deviceType);
            //同步设备状态变化
            parkDevices2.forEach(parkDevice -> deviceStatusSync(status, parkDevice));
            List<String> deviceNos = parkDevices2.stream().map(ParkDevice::getDeviceNo).collect(Collectors.toList());
            Map<String, String> deviceNoSnMap = parkDevices2.stream()
                    .collect(Collectors.toMap(ParkDevice::getDeviceNo, ParkDevice::getSerialNumber, (a, b) -> b));
            // 添加车场连接断开记录表
            List<HeartbeatOffline> heartbeatOfflines = heartbeatOfflineService.getNoFinishLastByDeviceNo(deviceNos);
            Iterator<HeartbeatOffline> iterator = heartbeatOfflines.iterator();
            while (iterator.hasNext()) {
                HeartbeatOffline heartbeatOffline = iterator.next();
                //最近心跳时间
                Long lastHeartbeatTime = snHeartbeatMap.get(deviceNoSnMap.get(heartbeatOffline.getDeviceNo()));
                if (lastHeartbeatTime != null) {
                    heartbeatOffline.setReconnectTime(lastHeartbeatTime);
                    heartbeatOffline.setOffTime(lastHeartbeatTime - heartbeatOffline.getLastConnectionTime());
                } else {
                    iterator.remove();
                }
            }
            heartbeatOfflineService.updateBatchById(heartbeatOfflines);
        }
    }

    public void batchModifyStatus2(List<ParkDevice> parkDeviceList, Map<String, Long> snHeartbeatMap, Integer status) {
        if (parkDeviceList == null || parkDeviceList.isEmpty()) {
            return;
        }
        //离线
        if (status == 2) {
            //同步设备状态变化
            parkDeviceList.forEach(parkDevice -> deviceStatusSync(status, parkDevice));
            List<ParkDevrecord> parkDevrecordList = new ArrayList<>();
            List<HeartbeatOffline> offlineList = parkDeviceList.stream()
                    .map(parkDevice -> {
                        //增加掉线记录
                        HeartbeatOffline heartbeatOffline = new HeartbeatOffline();
                        heartbeatOffline.setParkId(parkDevice.getParkId());
                        heartbeatOffline.setLastConnectionTime(snHeartbeatMap.get(parkDevice.getSerialNumber()));
                        heartbeatOffline.setDeviceNo(parkDevice.getDeviceNo());

                        //要更新成离线，且与上次状态不相同，才会写入报警记录
                        ParkDevrecord parkDevrecord = new ParkDevrecord();
                        parkDevrecord.setDeviceId(parkDevice.getId());
                        parkDevrecord.setStatus(2);
                        parkDevrecord.setReason("下线");
                        parkDevrecord.setWrongTime(new Date(heartbeatOffline.getLastConnectionTime() * 1000));
                        parkDevrecordList.add(parkDevrecord);

                        return heartbeatOffline;
                    }).collect(Collectors.toList());
            heartbeatOfflineService.saveBatch(offlineList);
            parkDevRecordService.saveBatch(parkDevrecordList);
        }
        if (status == 1) {
            //同步设备状态变化
            parkDeviceList.forEach(parkDevice -> deviceStatusSync(status, parkDevice));
            List<String> deviceNos = parkDeviceList.stream().map(ParkDevice::getDeviceNo).collect(Collectors.toList());
            Map<String, String> deviceNoSnMap = parkDeviceList.stream()
                    .collect(Collectors.toMap(ParkDevice::getDeviceNo, ParkDevice::getSerialNumber, (a, b) -> b));
            // 添加车场连接断开记录表
            List<HeartbeatOffline> heartbeatOfflines = heartbeatOfflineService.getNoFinishLastByDeviceNo(deviceNos);
            if (!heartbeatOfflines.isEmpty()) {
                Iterator<HeartbeatOffline> iterator = heartbeatOfflines.iterator();
                while (iterator.hasNext()) {
                    HeartbeatOffline heartbeatOffline = iterator.next();
                    //最近心跳时间
                    Long lastHeartbeatTime = snHeartbeatMap.get(deviceNoSnMap.get(heartbeatOffline.getDeviceNo()));
                    if (lastHeartbeatTime != null) {
                        heartbeatOffline.setReconnectTime(lastHeartbeatTime);
                        heartbeatOffline.setOffTime(lastHeartbeatTime - heartbeatOffline.getLastConnectionTime());
                    } else {
                        iterator.remove();
                    }
                }
                if (!heartbeatOfflines.isEmpty()) {
                    heartbeatOfflineService.updateBatchById(heartbeatOfflines);
                }
            }
        }
    }

    /**
     * 向坐席推送设备状态
     * @return
     */
    public void pushDeviceStatus(Long parkId, Integer status, Long channelId, Integer type){
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkId(parkId);
        ObjectResponse.notError(parkObjectResponse);
        ObjectResponse<ParkInoutdevice> objectResponse = parkService.getInoutDeviceById(channelId);
        ObjectResponse.notError(objectResponse);
        Park park = parkObjectResponse.getData();
        ParkInoutdevice parkInoutdevice = objectResponse.getData();
        WebsocketPushData websocketPushData = new WebsocketPushData();
        websocketPushData.setRecordType(3);
        //设备类型 200：超级盒子 201：摄像头 202:道闸 203:显示屏 204:语音对讲机
        websocketPushData.setType(type + 200);
        //设备状态，0初始1在线2离线3故障
        websocketPushData.setDeviceStatus(status);
        websocketPushData.setChannelId(parkInoutdevice.getInandoutCode());
        websocketPushData.setEnterNo(parkInoutdevice.getInandoutName());
        //websocketPushData.setExitNo(orderEnexRecord.getExitNo());
        websocketPushData.setParkCode(park.getParkCode());
        redisTemplate.convertAndSend(RedisMsgListener.TOPIC, JsonUtils.toString(websocketPushData));
    }

    /**
     * 获取更新时的实体对象
     *
     * @param status
     * @param deviceId
     * @param wrongTime
     * @return
     */
    private ParkDevrecord getInsertPara(Integer status, String reason, Long wrongTime, int deviceId) {
        ParkDevrecord parkDevrecord = new ParkDevrecord();
        parkDevrecord.setDeviceId(deviceId);
        parkDevrecord.setStatus(status);
        parkDevrecord.setReason(reason);
        parkDevrecord.setWrongTime(new Date(wrongTime * 1000));
        return parkDevrecord;
    }

    /**
     * 将 List<Map>对象转化为List<JavaBean>
     *
     * @param listMap
     * @param T
     * @return
     * @throws Exception
     */
    private <T> List<T> convertListMap2ListBean(List<Map<String, String>> listMap, Class<T> T)
            throws Exception {
        List<T> beanList = new ArrayList<>();
        if (listMap != null && !listMap.isEmpty()) {
            for (int i = 0, n = listMap.size(); i < n; i++) {
                Map<String, String> map = listMap.get(i);
                T bean = convertMap2Bean(map, T);
                beanList.add(bean);
            }
            return beanList;
        }
        return beanList;
    }

    /**
     * 将 Map对象转化为JavaBean
     *
     * @param map
     * @param T
     * @return
     * @throws Exception
     */
    private <T> T convertMap2Bean(Map<String, String> map, Class<T> T)
            throws Exception {
        if (map == null || map.size() == 0) {
            return null;
        }
        Object mvalue = null;
        Map<String, Object> newMap = new HashMap<>();
        Iterator<Map.Entry<String, String>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            String key = it.next().getKey();
            mvalue = map.get(key);
            newMap.put(key.toUpperCase(Locale.US), mvalue);
        }
        BeanInfo beanInfo = Introspector.getBeanInfo(T);
        T bean = T.newInstance();
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0, n = propertyDescriptors.length; i < n; i++) {
            PropertyDescriptor descriptor = propertyDescriptors[i];
            String propertyName = descriptor.getName();
            String upperPropertyName = propertyName.toUpperCase();

            if (newMap.keySet().contains(upperPropertyName)) {
                Object value = newMap.get(upperPropertyName);
                BeanUtils.copyProperty(bean, propertyName, value);
            }
        }
        return bean;
    }

    @Override
    public ObjectResponse<List<ParkDeviceDto>> getUserDeviceList(QueryDeviceRequest queryDeviceRequest) {
        try {
            String[] split = queryDeviceRequest.getParkCode().split(",");
            String parkid = parkDao.selectByCodes(split);
            PageHelper.startPage(queryDeviceRequest.getPageNo(), queryDeviceRequest.getPageSize());
            List<ParkDevice> parkDevices = parkDeviceDao.selectUserDeviceList(parkid, queryDeviceRequest.getAisleCode(),
                    queryDeviceRequest.getStatus(), queryDeviceRequest.getDeviceType(),queryDeviceRequest.getDeviceNo());

            if (CollectionUtils.isEmpty(parkDevices)) {
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
            }
            List<ParkDeviceDto> deviceDtos = Lists.newArrayList();
            //设置原因
            parkDevices.forEach(parkDevice -> {
                ParkDeviceDto parkDeviceDto = new ParkDeviceDto();
                parkDeviceDto.setId(parkDevice.getId());
                parkDeviceDto.setDeviceCode(parkDevice.getDeviceNo());
                parkDeviceDto.setSerialNumber(parkDevice.getSerialNumber());
                parkDeviceDto.setDeviceType(parkDevice.getType());
                parkDeviceDto.setStatus(parkDevice.getStatus());
                parkDeviceDto.setProductModel(parkDevice.getProductModel());
                parkDeviceDto.setFirmwareVersion(parkDevice.getFirmwareVersion());
                Park park = parkService.findByParkId(parkDevice.getParkId()).getData();
                if(park != null){
                    parkDeviceDto.setParkName(park.getParkName());
                }
                ParkInoutdevice parkInoutdevice = parkService.getInoutDeviceById((long) parkDevice.getChannelId()).getData();
                if(parkInoutdevice != null){
                    //设置通道名称
                    parkDeviceDto.setAisleName(parkInoutdevice.getInandoutName());
                    parkDeviceDto.setAisleCode(parkInoutdevice.getInandoutCode());
                }
                if (parkDevice.getStatus() == 3) {
                    //设置故障原因
                    parkDeviceDto.setReason(parkDeviceDao.getDeviceReason(parkDevice.getId()));
                }
                parkDeviceDto.setUpdateTime(parkDevice.getEndUpdatetime());
                deviceDtos.add(parkDeviceDto);
            });
            return ObjectResponse.success(deviceDtos);
        } catch (Exception e) {
            log.error("[坐席中心获取设备接口异常] [{}]",queryDeviceRequest, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    public ObjectResponse<Map<String, Object>> countUserDeviceList(QueryDeviceRequest queryDeviceRequest) {
        try {
            String[] split = queryDeviceRequest.getParkCode().split(",");
            String parkid = parkDao.selectByCodes(split);
            int count = parkDeviceDao.countUserDeviceList(parkid, queryDeviceRequest.getAisleCode(),
                    queryDeviceRequest.getStatus(), queryDeviceRequest.getDeviceType(),queryDeviceRequest.getDeviceNo());
            Map<String, Object> map = new HashMap<>();
            map.put("count", count);
            return ObjectResponse.success(map);
        } catch (Exception e) {
            log.error("[获取设备接口]操作失败: {}. queryDeviceRequest[{}]", e.getMessage(), queryDeviceRequest, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    /**
     * 批量获取通道信息
     *
     * @param parkCodeList
     * @return
     */
    @Override
    public ObjectResponse<ParkChannelListPage<ParkChannelInfo>> selectByParkCode(List<String> parkCodeList, Integer pageIndex, Integer pageSize) {
        com.github.pagehelper.Page<List<ParkInoutdevice>> parkListPage = PageHelper.startPage(pageIndex, pageSize);
        List<ParkChannelInfo> parkInoutdeviceList = parkInoutdeviceDao.selectByParkCode(parkCodeList);
        return ObjectResponse.success(new ParkChannelListPage<ParkChannelInfo>(parkListPage.getTotal(),String.valueOf(parkListPage.getPages()),parkInoutdeviceList));
    }

    /**
     *
     * 通道信息
     * @param parkCode
     * @param pageIndex
     * @param pageSize
     * @return
     */
    @Override
    public ObjectResponse<ParkChannelListPage<ParkInoutDeviceInfo>> selectChannelInfoByParkCode(String parkCode, Integer pageIndex, Integer pageSize) {
        com.github.pagehelper.Page<List<ParkInoutDeviceInfo>> parkListPage = PageHelper.startPage(pageIndex, pageSize);
        List<ParkInoutDeviceInfo> parkInoutDeviceInfoList = parkInoutdeviceDao.selectChannelInfoByParkCode(parkCode);
        return ObjectResponse.success(new ParkChannelListPage<ParkInoutDeviceInfo>(parkListPage.getTotal(),String.valueOf(parkListPage.getPages()),parkInoutDeviceInfoList));
    }

    @Override
    public ObjectResponse<ParkChannelListPage<ParkChannelInfo>> selectParkChannelInfoByParkId(List<Integer> parkIdList, Integer pageIndex, Integer pageSize) {
        com.github.pagehelper.Page<List<ParkInoutdevice>> parkListPage = PageHelper.startPage(pageIndex, pageSize);
        List<ParkChannelInfo> parkInoutdeviceList = parkInoutdeviceDao.selectParkChannelInfoByParkId(parkIdList);
        return ObjectResponse.success(new ParkChannelListPage<>(parkListPage.getTotal(),String.valueOf(parkListPage.getPages()),parkInoutdeviceList));
    }

    @Override
    public ObjectResponse<ParkInoutdevice> selectParkInoutdeviceByChannelCode(String channelCode) {
        ParkInoutdevice parkInoutdevice = parkService.getInoutDeviceByCode(channelCode).getData();
        List<String> channelCodes = new ArrayList<>(1);
        channelCodes.add(parkInoutdevice.getInandoutCode());
        List<Integer> statusList = Arrays.asList(0, 1, 2);
        List<Integer> deviceList = Arrays.asList(1, 5, 6, 4);
        List<ParkDevice> parkDeviceList = parkDeviceDao.selectDeviceSimpleList(parkInoutdevice.getParkId(),channelCodes,statusList,deviceList);
        parkInoutdevice.setParkId(null);
        parkInoutdevice.setDevices(parkDeviceList);
        return ObjectResponse.success(parkInoutdevice);
    }

    @Override
    public ObjectResponse<ParkChannelListPage<ParkDeviceInfo>> selectDeviceInfoSimpleList(List<Integer> parkId,List<Integer> statusList, Integer pageIndex, Integer pageSize) {
        List<Integer> deviceStatusList = Arrays.asList(1, 5, 4, 6);
        com.github.pagehelper.Page<List<ParkDeviceInfo>> parkListPage = PageHelper.startPage(pageIndex, pageSize);
        List<ParkDeviceInfo> parkDeviceInfoList = parkDeviceDao.selectDeviceInfoSimpleList(parkId,statusList,deviceStatusList);
        log.info("selectDeviceInfoSimpleList  parkDeviceInfoList [{}]",parkDeviceInfoList);
        return ObjectResponse.success(new ParkChannelListPage<>(parkListPage.getTotal(),String.valueOf(parkListPage.getPages()),parkDeviceInfoList));
    }

    /**
     * 新建编辑通道信息
     * @param parkInoutdevice
     * @return
     */
    @Override
    @Transactional
    public ObjectResponse<ParkInoutdevice> createChannel(ParkInoutdevice parkInoutdevice) {
        List<ParkDevice> parkDeviceList = parkInoutdevice.getDevices();
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkCode(parkInoutdevice.getParkCode());
        Park park = parkObjectResponse.getData();
        if(park == null){
            return ObjectResponse.failed(CodeConstants.ERROR_400,"车场编号不存在");
        }
        ParkInoutdevice  parkInoutdeviceFind = parkInoutdeviceDao.checkChannelNameByParkId(park.getId(),parkInoutdevice.getInandoutName());
        if(Objects.nonNull(parkInoutdeviceFind)){
            return ObjectResponse.failed(CodeConstants.ERROR_400,"通道名称重复");
        }
        parkInoutdevice.setParkId(park.getId());
        parkInoutdevice.setStatus(0);
        parkInoutdevice.setAdder(StringUtils.isBlank(parkInoutdevice.getAdder())?"third":parkInoutdevice.getAdder());
        checkParkInoutDeviceVipType(parkInoutdevice,park.getId());
        parkInoutdevice.setCreateTime(new Date());
        if (!CollectionUtils.isEmpty(parkDeviceList)){
            for (ParkDevice parkDevice : parkDeviceList) {
                Integer checkDevie = checkCreateParkDeviceBefore(parkInoutdevice,parkDevice);
                if (!new Integer(0).equals(checkDevie)){
                    return ObjectResponse.failed(CodeConstants.ERROR_400,
                            parserErrorType(checkDevie));
                }
            }
        }
        ParkRegion region = parkRegionDao.selectOutByParkid(park.getId());
        if(Objects.nonNull(region)){
            parkInoutdevice.setRegionId(region.getId());
        }
        parkInoutdeviceDao.insert(parkInoutdevice);
        sendInfoService.save(new SendInfo(park.getId(), parkInoutdevice.getId(), DownServiceEnum.通道信息.getServiceType()));
        removeChannelInfoFromRedis(parkInoutdevice.getId(), parkInoutdevice.getInandoutCode());
        if (CollectionUtils.isNotEmpty(parkDeviceList)){
            for (ParkDevice parkDevice : parkDeviceList) {
                createParkDevice(parkInoutdevice, parkDevice);
            }
        }
        log.info("createChannel data [{}]",parkInoutdevice);
        clearParkInoutdevice(parkInoutdevice);
        return ObjectResponse.success(parkInoutdevice);
    }
    /**
     * 更新通道信息
     * @param parkInoutdevice
     * @return
     */
    @Override
    @Transactional
    public ObjectResponse<ParkInoutdevice> updateChannel(ParkInoutdevice parkInoutdevice) {
        log.info("parkInoutdevice [{}]",parkInoutdevice);
        Park park = parkService.findByParkCode(parkInoutdevice.getParkCode()).getData();
        if(park == null || StringUtils.isBlank(parkInoutdevice.getInandoutCode())){
            return ObjectResponse.failed(CodeConstants.ERROR_400,"车场编号不存在");
        }
        parkInoutdevice.setUpdateTime(new Date());
        parkInoutdevice.setParkId(park.getId());
        ParkInoutdevice  parkInoutdeviceCheck = parkInoutdeviceDao.checkChannelNameByParkId(park.getId(),parkInoutdevice.getInandoutName());
        if(Objects.nonNull(parkInoutdeviceCheck)&&!parkInoutdeviceCheck.getInandoutCode().equals(parkInoutdevice.getInandoutCode())){
            return ObjectResponse.failed(CodeConstants.ERROR_400,"通道名称重复");
        }

        ObjectResponse<ParkInoutdevice> channelResp = parkService.getInOutDeviceByCode(park.getId(),parkInoutdevice.getInandoutCode());
        if (!ObjectResponse.isSuccess(channelResp)){
            return ObjectResponse.failed(CodeConstants.ERROR_400,"通道编号不存在");
        }
        parkInoutdevice.setId(channelResp.getData().getId());
        List<ParkDevice> parkDeviceList = parkInoutdevice.getDevices();
        if (Objects.nonNull(parkDeviceList)) {
            for (ParkDevice parkDevice : parkDeviceList) {
                if (StringUtils.isEmpty(parkDevice.getDeviceNo())) {
                    Integer checkDevie = checkCreateParkDeviceBefore(parkInoutdevice, parkDevice);
                    if (!new Integer(0).equals(checkDevie)) {
                        return ObjectResponse.failed(CodeConstants.ERROR_400,
                                parserErrorType(checkDevie));
                    }
                } else {
                    ParkDevice parkDeviceCheck = parkDeviceDao.selectDeviceOnlyBySerialNumber(parkDevice.getSerialNumber());
                    log.info("parkDeviceCheck [{}]",parkDeviceCheck);
                    ParkDevice parkDeviceCheckIp = parkDeviceDao.checkDeviceByIP(park.getId(), parkDevice.getIp());
                    log.info("parkDeviceCheckIp [{}]",parkDeviceCheckIp);
                    ParkDevice parkDeviceMaster = parkDeviceDao.checkDeviceByMaster(parkInoutdevice.getParkId(),parkInoutdevice.getId());
                    log.info("parkDeviceMaster [{}]",parkDeviceMaster);
                    boolean checkSerial = Objects.nonNull(parkDeviceCheck) && !parkDeviceCheck.getDeviceNo().equals(parkDevice.getDeviceNo());
                    boolean checkIp = Objects.nonNull(parkDeviceCheckIp) && !parkDeviceCheckIp.getDeviceNo().equals(parkDevice.getDeviceNo());
                    boolean checkMaster = Objects.nonNull(parkDeviceMaster) && !parkDeviceMaster.getDeviceNo().equals(parkDevice.getDeviceNo()) && new Integer(1).equals(parkDevice.getIsMaster());
                    log.info("parkDevice [{}]",parkDevice);
                    if (checkSerial || checkIp || checkMaster) {
                        return ObjectResponse.failed(CodeConstants.ERROR_400, checkSerial ? "设备序列号重复" : checkIp ?"设备ip重复":"主相机配置重复");
                    }
                }

            }
        }
        checkParkInoutDeviceVipType(parkInoutdevice,park.getId());
        parkInoutdeviceDao.updateById(parkInoutdevice);
        sendInfoService.save(new SendInfo(park.getId(), parkInoutdevice.getId(), DownServiceEnum.通道信息.getServiceType()));
        removeChannelInfoFromRedis(parkInoutdevice.getId(), parkInoutdevice.getInandoutCode());
        if (Objects.nonNull(parkDeviceList)) {
            for (ParkDevice parkDevice : parkDeviceList) {
                parkDevice.setParkId(parkInoutdevice.getParkId());
                if (StringUtils.isEmpty(parkDevice.getDeviceNo())) {
                    createParkDevice(parkInoutdevice, parkDevice);
                } else {
                    if (new Integer(1).equals(parkDevice.getType())){
                        ParkDevice parkDeviceIndex = new ParkDevice();
                        parkDeviceIndex.setType(1);
                        parkDeviceIndex.setDeviceNo(parkDevice.getDeviceNo());
                        ParkDevice parkDeviceFindIn = parkDeviceDao.selectByParam(parkDeviceIndex);
                        log.info("parkDeviceFindIn [{}]",parkDeviceFindIn);
                        if(new Integer(1).equals(parkDevice.getIsVoiceLed())){
                            ParkDevice parkDeviceScreen = parkDeviceDao.selectDeviceByTypeAndIp(parkInoutdevice.getId(),3,Objects.nonNull(parkDeviceFindIn)?
                                    parkDeviceFindIn.getIp():parkDevice.getIp());
                            log.info("parkDeviceScreen [{}]",parkDeviceScreen);
                            if (Objects.isNull(parkDeviceScreen)){
                                //屏幕
                                createDeviceOfScreenAndGate(parkInoutdevice,parkDevice,3);
                            }else {
                                parkDeviceScreen.setIp(parkDevice.getIp());
                                parkDeviceDao.updateByDeviceNo(parkDeviceScreen);
                                removeDeviceInfoFromRedis(parkDeviceScreen.getSerialNumber());
                            }
                        }else {
                            ParkDevice parkDeviceScreen = parkDeviceDao.selectDeviceByTypeAndIp(parkInoutdevice.getId(),3,Objects.nonNull(parkDeviceFindIn)?
                                    parkDeviceFindIn.getIp():parkDevice.getIp());
                            if (Objects.nonNull(parkDeviceScreen)){
                                parkDeviceScreen.setDelFlag(1);
                                parkDeviceDao.updateByDeviceNo(parkDeviceScreen);
                                removeDeviceInfoFromRedis(parkDeviceScreen.getSerialNumber());
                            }
                        }
                        if(new Integer(1).equals(parkDevice.getIsParkGate())){
                            ParkDevice parkDeviceGate = parkDeviceDao.selectDeviceByTypeAndIp(parkInoutdevice.getId(),2,Objects.nonNull(parkDeviceFindIn)?
                                    parkDeviceFindIn.getIp():parkDevice.getIp());
                            log.info("parkDeviceGate [{}]  [{}]",parkDeviceGate,Objects.isNull(parkDeviceGate));
                            if (Objects.isNull(parkDeviceGate)){
                                createDeviceOfScreenAndGate(parkInoutdevice,parkDevice,2);
                            }else {
                                parkDeviceGate.setIp(parkDevice.getIp());
                                parkDeviceDao.updateByDeviceNo(parkDeviceGate);
                                removeDeviceInfoFromRedis(parkDeviceGate.getSerialNumber());
                            }
                        }else {
                            ParkDevice parkDeviceGate = parkDeviceDao.selectDeviceByTypeAndIp(parkInoutdevice.getId(),2,Objects.nonNull(parkDeviceFindIn)?
                                    parkDeviceFindIn.getIp():parkDevice.getIp());
                            if(Objects.nonNull(parkDeviceGate)){
                                parkDeviceGate.setDelFlag(1);
                                parkDeviceDao.updateByDeviceNo(parkDeviceGate);
                                removeDeviceInfoFromRedis(parkDeviceGate.getSerialNumber());
                            }
                        }
                    }
                    parkDeviceDao.updateByDeviceNo(parkDevice);
                    removeDeviceInfoFromRedis(parkDevice.getSerialNumber());
                    clearParkDevice(parkDevice);
                }


            }
        }
        clearParkInoutdevice(parkInoutdevice);
        return ObjectResponse.success(parkInoutdevice);
    }

    private void removeChannelInfoFromRedis(Long channelId, String channelCode) {
        redisTemplate.delete(Arrays.asList(RedisKeyConstants.KEY_PREFIX_PARK_CHANNEL + channelId,
                RedisKeyConstants.KEY_PREFIX_PARK_CHANNEL_CODE + channelCode,
                RedisKeyConstants.KEY_PREFIX_GRAY + RedisKeyConstants.KEY_PREFIX_PARK_CHANNEL + channelId,
                RedisKeyConstants.KEY_PREFIX_GRAY + RedisKeyConstants.KEY_PREFIX_PARK_CHANNEL_CODE + channelCode));
    }

    private void removeDeviceInfoFromRedis(String serialNumber) {
        if (!StringUtils.isEmpty(serialNumber)) {
            redisTemplate.delete(RedisKeyConstants.KEY_PREFIX_PARK_DEVICE_SERIAL_NUMBER + serialNumber);
        }
    }

    private void checkParkInoutDeviceVipType(ParkInoutdevice parkInoutdevice,Long parkId){
        if (new Integer(1).equals(parkInoutdevice.getIsAllowVipCar())){
            List<Integer> integerList = vipTypeDao.selectByParkId(parkId);
            if (Objects.nonNull(integerList)){
                List<String> stringList = new ArrayList<>(integerList.size());
                for (Integer i:integerList){
                    if (Objects.nonNull(i)){
                        stringList.add(String.valueOf(i));
                    }
                }
                String ids = String.join(",",stringList);
                log.info("checkParkInoutDeviceVipType vip类型 ids [{}]",ids);
                parkInoutdevice.setVipCarTypeId(ids);
            }
        }
    }

    private Integer checkCreateParkDeviceBefore(ParkInoutdevice parkInoutdevice ,ParkDevice parkDevice){
        if (!StringUtils.isEmpty(parkDevice.getSerialNumber())) {
            ParkDevice parkDeviceCheck = parkDeviceDao.selectDeviceOnlyBySerialNumber( parkDevice.getSerialNumber());
            if ( Objects.nonNull(parkDeviceCheck) ){
                return 1;
            }
        }
        if (Objects.nonNull(parkDevice.getIp())) {
            ParkDevice parkDeviceCheckIp = parkDeviceDao.checkDeviceByIP(parkInoutdevice.getParkId(), parkDevice.getIp());
            if (Objects.nonNull(parkDeviceCheckIp)) {
                return 2;
            }
        }
        //相机检测 主从
        if (new Integer(1).equals(parkDevice.getType())){
            if (new Integer(1).equals(parkDevice.getIsMaster())){
                ParkDevice parkDeviceMaster = parkDeviceDao.checkDeviceByMaster(parkInoutdevice.getParkId(),parkInoutdevice.getId());
                if (Objects.nonNull(parkDeviceMaster)){
                    return 3;
                }
            }else {
                ParkDevice parkDeviceSecond = parkDeviceDao.checkDeviceBySecond(parkInoutdevice.getParkId(),parkInoutdevice.getId());
                if(Objects.nonNull(parkDeviceSecond)){
                    return 5;
                }
            }
        }
        if(Objects.nonNull(parkInoutdevice.getId())) {
            if (!new Integer(1).equals(parkDevice.getType())) {
                ParkDevice parkDeviceType = parkDeviceDao.selectDeviceByTypeAndIp(parkInoutdevice.getId(),parkDevice.getType(),null);
                if (Objects.nonNull(parkDeviceType)){
                    return 4;
                }
            }
        }
        return 0;
    }

    private String parserErrorType(Integer type){
        String codeContent ;
        switch (type){
            case 1:
                codeContent = "设备序列号重复";
                break;
            case 2:
                codeContent = "设备ip重复";
                break;
            case 3:
                codeContent = "主相机配置重复";
                break;
            case 4:
                codeContent = "已存在同类型设备";
                break;
            case 5:
                codeContent = "从相机配置重复";
                break;
            default:
                codeContent = "default";
                break;
        }
        return codeContent;
    }

    @Override
    public ObjectResponse<ParkDevice> createParkDevice(ParkInoutdevice parkInoutdevice ,ParkDevice parkDevice) {
        parkDevice.setParkId(parkInoutdevice.getParkId());
        parkDevice.setChannelId(parkInoutdevice.getId().intValue());
        parkDevice.setStatus(1);
        parkDevice.setLinetype(Objects.isNull(parkDevice.getLinetype()) ? 0 : parkDevice.getLinetype());
        parkDevice.setDelFlag(NumberUtils.toPrimitive(parkDevice.getDelFlag()));
        parkDevice.setModelType(NumberUtils.toPrimitive(parkDevice.getModelType(), 1));
        parkDevice.setCallMethods(NumberUtils.toPrimitive(parkDevice.getCallMethods(), 2));
        parkDevice.setIsMaster(NumberUtils.toPrimitive(parkDevice.getIsMaster(), 1));
        parkDevice.setIsDualcamera(NumberUtils.toPrimitive(parkDevice.getIsDualcamera()));
        parkDevice.setAdder(StringUtils.isBlank(parkDevice.getAdder()) ? "third" : parkDevice.getAdder());
        parkDevice.setDeviceNo("D" + System.currentTimeMillis() + new Random().nextInt(99));
        parkDevice.setCreateTime(new Date());
        parkDeviceDao.insert(parkDevice);
        removeDeviceInfoFromRedis(parkDevice.getSerialNumber());
        createGateAndScreen(parkInoutdevice, parkDevice);
        clearParkDevice(parkDevice);
        return ObjectResponse.success(parkDevice);
    }

    private void createDeviceOfScreenAndGate(ParkInoutdevice parkInoutdevice ,ParkDevice parkDevice,Integer type){
        log.info("createDeviceOfScreenAndGate parkDevice [{}] type [{}]",parkDevice,type);
        ParkDevice parkDeviceScreen = new ParkDevice();
        parkDeviceScreen.setParkId(parkInoutdevice.getParkId());
        parkDeviceScreen.setChannelId(parkInoutdevice.getId().intValue());
        parkDeviceScreen.setType(type);
        parkDeviceScreen.setModelType(parkDevice.getModelType());
        parkDeviceScreen.setDeviceNo("D"+System.currentTimeMillis()+new Random().nextInt(99));
        parkDeviceScreen.setSerialNumber(""+System.currentTimeMillis()+new Random().nextInt(99));
        parkDeviceScreen.setIp(parkDevice.getIp());
        parkDeviceScreen.setCallMethods(parkDevice.getCallMethods());
        parkDeviceScreen.setStatus(1);
        parkDeviceScreen.setCreateTime(new Date());
        parkDeviceScreen.setUpdateTime(new Date());
        parkDeviceScreen.setAdder(parkDevice.getAdder());
        parkDeviceScreen.setDelFlag(0);
        parkDeviceDao.insert(parkDeviceScreen);
        removeDeviceInfoFromRedis(parkDeviceScreen.getSerialNumber());
    }

    private void createGateAndScreen(ParkInoutdevice parkInoutdevice ,ParkDevice parkDevice){
        if(new Integer(1).equals(parkDevice.getType())){
            if (new Integer(1).equals(parkDevice.getIsVoiceLed())){
                createDeviceOfScreenAndGate(parkInoutdevice ,parkDevice,3);

            }
            if (new Integer(1).equals(parkDevice.getIsParkGate())){
                //道闸
                createDeviceOfScreenAndGate(parkInoutdevice ,parkDevice,2);

            }
        }

    }

    private void clearParkDevice(ParkDevice parkDevice) {
            parkDevice.setAdder(null);
            parkDevice.setLinetype(null);
            parkDevice.setEzopenId(null);
            parkDevice.setDelFlag(null);
            parkDevice.setModelType(null);
            parkDevice.setCallMethods(null);
            parkDevice.setCreateTime(null);
            parkDevice.setUpdateTime(null);
            parkDevice.setParkId(null);
            parkDevice.setId(null);
            parkDevice.setIsDualcamera(null);
            parkDevice.setChannelId(null);
            parkDevice.setStatus(null);

    }
    private void clearParkInoutdevice(ParkInoutdevice parkInoutdevice){
        parkInoutdevice.setParkId(null);
        parkInoutdevice.setId(null);
    }

    @Override
    public ObjectResponse<Integer> updateParkDevice(ParkDevice parkDevice) {
        ParkDevice parkDeviceFind = parkDeviceDao.selectByParam(parkDevice);
        parkDevice.setId(parkDeviceFind.getId());
        removeDeviceInfoFromRedis(parkDeviceFind.getSerialNumber());
        return ObjectResponse.success(parkDeviceDao.updateByDeviceNo(parkDevice));
    }

    @Override
    public ObjectResponse<ParkDeviceVo> getParkDeviceVo(String serialNumber) {
        ObjectResponse<ParkDevice> parkDeviceResp = getDeviceBySerialNumber(serialNumber);
        ParkDevice parkDevice = parkDeviceResp.getData();
        if (Objects.isNull(parkDevice)) {
            return ObjectResponse.success();
        }
        ParkDeviceVo parkDeviceVo = new ParkDeviceVo();
        org.springframework.beans.BeanUtils.copyProperties(parkDevice, parkDeviceVo);
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkId(parkDevice.getParkId());
        if (ObjectResponse.isSuccess(parkObjectResponse)) {
            Park park = parkObjectResponse.getData();
            parkDeviceVo.setParkName(park.getParkName());
            parkDeviceVo.setParkCode(park.getParkCode());
            ParkTrusteeship parkTrusteeship = SpringUtils.getBean(IParkTrusteeshipService.class).getParkTrusteeshipByParkId(park.getId()).getData();
            if (Objects.nonNull(parkTrusteeship)) {
                Date currentDate = new Date();
                parkDeviceVo.setTrusteeshipStatus(DateUtil.compare(currentDate, parkTrusteeship.getStartTime()) < 0 ? 1 : (DateUtil.compare(currentDate,
                        parkTrusteeship.getStartTime()) > 0 && DateUtil.compare(currentDate, parkTrusteeship.getEndTime()) < 0 ? 2 : 3) );
                parkDeviceVo.setTrusteeshipEndTime(parkTrusteeship.getEndTime());
            } else {
                parkDeviceVo.setTrusteeshipStatus(0);
            }
        }
        ObjectResponse<ParkInoutdevice> inoutDeviceObjectResponse = parkService.getInoutDeviceById((long)parkDevice.getChannelId());
        if (ObjectResponse.isSuccess(inoutDeviceObjectResponse)) {
            ParkInoutdevice parkInoutdevice = inoutDeviceObjectResponse.getData();
            parkDeviceVo.setAisleCode(parkInoutdevice.getInandoutCode());
            parkDeviceVo.setAisleName(parkInoutdevice.getInandoutName());
            parkDeviceVo.setAisleType(parkInoutdevice.getInandoutType());
        }
        return ObjectResponse.success(parkDeviceVo);
    }
}
