package com.icetech.basics.service.device.impl;

import com.icetech.basics.dao.device.HeartbeatOfflineDao;
import com.icetech.basics.domain.entity.device.HeartbeatOffline;
import com.icetech.basics.service.device.HeartbeatOfflineService;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 设备掉线
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2021-10-28
 */
@Service
public class HeartbeatOfflineServiceImpl extends BaseServiceImpl<HeartbeatOfflineDao, HeartbeatOffline> implements HeartbeatOfflineService {

    @Autowired
    private HeartbeatOfflineDao heartbeatOfflineDao;

    @Override
    public List<HeartbeatOffline> getNoFinishLastByDeviceNo(List<String> deviceNos) {
        return heartbeatOfflineDao.getNoFinishLastByDeviceNo(deviceNos);
    }

    @Override
    public List<HeartbeatOffline> getNoFinishLastByParkId(List<Long> parkIdList) {
        return heartbeatOfflineDao.getNoFinishLastByParkId(parkIdList);
    }

    @Override
    public List<HeartbeatOffline> getNoFinishChargeLastByChargeId(Long parkId, List<String> chargeIds) {
        return heartbeatOfflineDao.getNoFinishChargeLastByChargeId(parkId, chargeIds);
    }
}
