package com.icetech.basics.service.charge;

import com.icetech.basics.dao.charge.ParkChargeconfigDao;
import com.icetech.cloudcenter.api.fee.ChargeService;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.basics.utils.SpringUtils;
import com.icetech.common.utils.DateTools;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
public class FeeParamHolder extends BaseFeeParamHolder {

    public FeeParamHolder(QueryOrderFeeRequest queryOrderFeeRequest, OrderInfo orderInfo, ParkConfig parkConfig, Park park) {
        this.queryOrderFeeRequest = queryOrderFeeRequest;
        this.orderInfo = orderInfo;
        this.park = park;
        this.parkConfig = parkConfig;
        if (queryOrderFeeRequest.getExitTime() != null) {
            this.queryTime = queryOrderFeeRequest.getExitTime();
        } else if (orderInfo.getExitTime() != null) {
            this.queryTime = orderInfo.getExitTime();
        } else {
            this.queryTime = DateTools.unixTimestamp();
        }
        this.endTime = queryTime;
        this.chargeService = SpringUtils.getBean(ChargeService.class);
        this.parkChargeconfigDao = SpringUtils.getBean(ParkChargeconfigDao.class);
    }
    public FeeParamHolder(ParkConfig parkConfig, ParkChargeconfig parkChargeconfig) {
        this.parkConfig = parkConfig;
        this.parkChargeconfigMap.put(parkChargeconfig.getId(), parkChargeconfig);

        this.chargeService = SpringUtils.getBean(ChargeService.class);
        this.parkChargeconfigDao = SpringUtils.getBean(ParkChargeconfigDao.class);
    }

}
