package com.icetech.basics.sentinel;

import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowException;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.ResponseUtils;
import lombok.extern.slf4j.Slf4j;

/**
 * 降级异常工具类
 */
@Slf4j
public class ExceptionUtils {

    /**
     * 默认的 fallback 函数名称，可选项，
     * 通常用于通用的 fallback 逻辑（即可以用于很多服务或方法）。
     * 默认 fallback 函数可以针对所有类型的异常（除了 exceptionsToIgnore 里面排除掉的异常类型）进行处理。
     * 若同时配置了 fallback 和 defaultFallback，则只有 fallback 会生效。
     * @param throwable
     * @return
     */
    public static ObjectResponse defaultFallbackHandle(Throwable throwable) throws Throwable {
        if (throwable instanceof DegradeException){
            DegradeRule rule = ((DegradeException) throwable).getRule();
            log.warn("[监控埋点]降级通知, 资源名称：{}", rule.getResource(), throwable);
        }else if (throwable instanceof FlowException){
            FlowRule rule = ((FlowException) throwable).getRule();
            log.warn("[监控埋点]限流通知, 资源名称：{}", rule.getResource(), throwable);
        }else{
            throw throwable;
        }
        return ObjectResponse.failed(CodeConstants.ERROR_429);
    }

    public static void handleException(BlockException ex) {
        log.info("Oops: {}", ex.getClass().getCanonicalName());
    }
}
