package com.icetech.basics.dao.park;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.domain.park.ParkConfigInfo;
import com.icetech.cloudcenter.domain.park.ParkConfigInfoFind;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import org.apache.ibatis.annotations.Param;

/**
 * 停车场系统配置表
 *
 * Created by wangzw on '2018-10-29 09:55:14'.
 */
public interface ParkConfigDao extends SuperMapper<ParkConfig> {
    /**
     * 车场id查询
     */
    default ParkConfig selectByParkId(long parkId) {
        return selectLimitOne(Wrappers.lambdaQuery(ParkConfig.class).eq(ParkConfig::getParkId, parkId));
    }

    /**
     * 车场code查询免费时长
     * @param parkCode
     * @return
     */
    Long selectFreeTimeByParkCode(String parkCode);

    ParkConfig selectByParkCode(String parkCode);

    /**
     * 新建车场配置
     * @param parkConfigInfo
     * @return
     */
    Integer saveParkConfigInfo(@Param("parkConfigInfo") ParkConfigInfo parkConfigInfo);

    /**
     * 更新车场配置
     * @param parkConfigInfo
     * @return
     */
    Integer updateParkConfigInfo(ParkConfigInfo parkConfigInfo);

    ParkConfigInfoFind selectParkConfigInfoByParkCode(String parkCode);

    default Integer selectCountByParkId(long parkId) {
        return selectCount(Wrappers.lambdaQuery(ParkConfig.class).eq(ParkConfig::getParkId, parkId));
    }
}
