package com.icetech.basics.dao.device;

import com.icetech.basics.domain.entity.device.ParkDevrecord;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface ParkDevrecordDao extends SuperMapper<ParkDevrecord> {

    /**
     * 获取设备列表信息
     * @param parkId
     * @param deviceNo
     * @param startTime
     * @param endTime
     * @param deviceType
     * @return
     */
    List<ParkDevrecord> selectDeviceAlarmList(@Param("parkId") String parkId, @Param("deviceNo") String deviceNo,
                                           @Param("startTime") String startTime, @Param("endTime") String endTime, @Param("deviceType")List<Integer> deviceType);

    /**
     * 统计报警总条数
     * @param parkId
     * @param deviceNo
     * @param startTime
     * @param endTime
     * @param deviceType
     * @return
     */
    int countDeviceAlarmList(@Param("parkId") String parkId, @Param("deviceNo") String deviceNo,
                             @Param("startTime") String startTime, @Param("endTime") String endTime, @Param("deviceType")List<Integer> deviceType);
}
