package com.icetech.basics.dao.device;

import com.icetech.cloudcenter.domain.device.ParkDeviceInfo;
import com.icetech.cloudcenter.domain.response.DeviceListDTO;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

public interface ParkDeviceDao extends SuperMapper<ParkDevice> {

    int updateByDeviceNo(ParkDevice parkDevice);

    /**
     * Load查询
     */
    ParkDevice load(@Param("id") int id);

    /**
     * 获取设备列表信息
     *
     * @param parkId
     * @param aisleCode
     * @param status
     * @param deviceType
     * @return
     */
    List<ParkDevice> selectDeviceList(@Param("parkId") Long parkId, @Param("aisleCode") List<String> aisleCode,
                                      @Param("status") List<Integer> status, @Param("deviceType") List<Integer> deviceType);

    List<ParkDevice> selectDeviceSimpleList(@Param("parkId") Long parkId, @Param("aisleCode") List<String> aisleCode,
                                            @Param("status") List<Integer> status, @Param("deviceType") List<Integer> deviceType);

    List<ParkDeviceInfo> selectDeviceInfoSimpleList(@Param("parkIds") List<Integer> parkId,
                                                    @Param("status") List<Integer> status, @Param("deviceType") List<Integer> deviceType);

    ParkDevice selectDeviceOnlyBySerialNumber(@Param("serialNumber") String serialNumber);

    ParkDevice checkDeviceByIP(@Param("parkId") Long parkId, @Param("ip") String ip);

    ParkDevice checkDeviceByMaster(@Param("parkId") Long parkId, @Param("channelId") Long channelId);

    ParkDevice checkDeviceBySecond(@Param("parkId") Long parkId, @Param("channelId") Long channelId);

    ParkDevice selectDeviceByTypeAndIp(@Param("channelId") Long channelId, @Param("type") Integer type, @Param("ip") String ip);

    /**
     * 获取设备的故障原因
     *
     * @param deviceId
     * @return
     */
    String getDeviceReason(@Param("deviceId") Integer deviceId);

    /**
     * @param parkId
     * @param serialNumber
     * @return
     */
    ParkDevice selectDeviceBySerialNumber(@Param("parkId") Long parkId, @Param("serialNumber") String serialNumber);

    /**
     * 根据设备编号获取设备信息
     *
     * @param serialNumber
     * @return
     */
    List<ParkDevice> selectWayDetailByvid(@Param("serialNumber") String serialNumber);

    /**
     * 根据通道编号获取设备
     *
     * @param parkId
     * @param channelId
     * @return
     */
    ParkDevice selectDeviceByAisleCode(@Param("parkId") Long parkId, @Param("channelId") Long channelId);

    /**
     * 更新状态
     *
     * @param parkId
     * @param endUpdatetime
     * @return
     */
    int updateStatus(@Param("parkId") Long parkId, @Param("deviceNo") String deviceNo, @Param("status") Integer status, @Param("endUpdatetime") Date endUpdatetime);

    /**
     * 查询设备
     *
     * @param parkDevice
     * @return
     */
    ParkDevice selectByParam(ParkDevice parkDevice);

    /**
     * 查询已删除的设备设备
     *
     * @param parkDevice
     * @return
     */
    ParkDevice selectDeleteById(ParkDevice parkDevice);

    /**
     * 根据设备类型查询所有设备
     *
     * @param dtype
     * @return
     */
    List<ParkDevice> selectDeviceListBytype(@Param("dtype") int dtype);

    /**
     * @param parkId
     * @param type
     * @return
     */
    List<ParkDevice> selectDeviceListByParkIdAndType(@Param("parkId") Long parkId, @Param("type") Integer type);

    List<ParkDevice> selectDeviceListByChannelId(@Param("channelId") Long channelId, @Param("type") Integer type);
    List<ParkDevice> selectDeviceListByChannelIds(@Param("channelIds") List<Long> channelIds, @Param("type") Integer type);

    List<ParkDevice> selectDeviceListByParkIdAndChannelId(@Param("parkId") Long parkId, @Param("channelId") Integer channelId, @Param("deviceType") int deviceType);

    /**
     * 当前登录用户获取设备列表信息
     *
     * @param parkId
     * @param aisleCode
     * @param status
     * @param deviceType
     * @return
     */
    List<ParkDevice> selectUserDeviceList(@Param("parkId") String parkId, @Param("aisleCode") List<String> aisleCode,
                                          @Param("status") List<Integer> status, @Param("deviceType") List<Integer> deviceType, @Param("deviceNo") String deviceNo);

    /**
     * 当前登录用户获取设备列表条数
     *
     * @param parkId
     * @param aisleCode
     * @param status
     * @param deviceType
     * @return
     */
    int countUserDeviceList(@Param("parkId") String parkId, @Param("aisleCode") List<String> aisleCode,
                            @Param("status") List<Integer> status, @Param("deviceType") List<Integer> deviceType, @Param("deviceNo") String deviceNo);

    /**
     * @param parkId
     * @param type
     * @return
     */
    List<ParkDevice> selectDeviceListByParkIdAndType(@Param("parkId") Long parkId, @Param("type") int type);

    /**
     * 当前登录用户获取设备列表信息
     *
     * @param parkId
     * @param inandoutCode
     * @param type
     * @return
     */
    List<ParkDevice> selectDeviceListByChannel(@Param("parkId") Long parkId, @Param("inandoutCode") String inandoutCode, @Param("type") Integer type);


    /**
     * 根据车场ID和通道编号查询设备
     *
     * @param parkId
     * @return
     */
    List<ParkDevice> selectDeviceListByParkChannel(@Param("parkId") Long parkId, @Param("channelId") Long channelId);

    List<ParkDevice> selectDeviceListByParkIdAndRegionId(@Param("parkId") Long parkId, @Param("regionId") Integer regionId, @Param("deviceType") int deviceType);

    List<ParkDevice> selectDevicesByParkChannel(@Param("parkId") Long parkId, @Param("channelIds") List<Long> channelIds, @Param("type") Integer type);

    /**
     * 查询可升级设备列表
     *
     * @param parkIdList
     * @param type
     * @param deviceStatus
     * @param productModel
     * @param serialNumber
     * @return
     */
    List<DeviceListDTO> selectUpgradeList(@Param("parkIdList") List<Long> parkIdList, @Param("type") Integer type, @Param("status") Integer deviceStatus, @Param("productModel") String productModel, @Param("serialNumber") String serialNumber);

    ParkDevice getByChannelId(@Param("parkId") long parkId, @Param("channelId") long channelId, @Param("type") int type);

    ParkDevice getByDeviceNo(@Param("parkId") long parkId, @Param("deviceNo") String deviceNo);

    /**
     * 批量更新设备状态
     *
     * @param sns
     * @param deviceType
     * @param oldStatus
     * @return
     */
    int batchUpdateStatus(@Param("sns") List<String> sns, @Param("deviceType") Integer deviceType,
                          @Param("oldStatus") Integer oldStatus, @Param("newStatus") Integer newStatus);

    /**
     * 查询设备状态和实际状态不一致的设备SN列表
     *
     * @param sns
     * @param deviceType
     * @param neqStatus
     * @return
     */
    List<String> selectFailStatusList(@Param("sns") List<String> sns, @Param("deviceType") Integer deviceType,
                                      @Param("neqStatus") Integer neqStatus);

    /**
     * 根据SN集合和设备类型查询
     *
     * @param sns
     * @param deviceType
     * @return
     */
    List<ParkDevice> selectListBySns(@Param("sns") List<String> sns, @Param("deviceType") int deviceType);
}
