package com.icetech.basics.dao.charge;

import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface ParkChargeconfigDao extends SuperMapper<ParkChargeconfig> {
    ParkChargeconfig selectByPrimaryKey(Integer id);

    /**
     * 获取车场默认的计费规则
     * @param parkId
     * @return
     */
    ParkChargeconfig selectDefaultBill(Long parkId);
    /**
     * 查询车场的某个计费规则（包括删除的）
     * @param parkId
     * @return
     */
    List<ParkChargeconfig> selectAllCofigs(Long parkId);
    /**
     * 查询车场的所有计费规则
     * @param parkId
     * @return
     */
    List<ParkChargeconfig> selectByParkId(Long parkId);

    /**
     *
     * @param parkId
     * @param billtypecode
     * @return
     */
    ParkChargeconfig selectByParkIdAndBillCode(@Param("parkId") Long parkId, @Param("billtypecode") String billtypecode);

    ParkChargeconfig selectByParkIdAndBillCodeWithoutDelFlag(@Param("parkId") Long parkId, @Param("billtypecode") String billtypecode);
}
