package com.icetech.basics.dao.apk;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.domain.entity.ApkVersion;
import com.icetech.db.mybatis.base.mapper.SuperMapper;

/**
 * <p>
 * 安卓app管理 Mapper 接口
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-04-02
 */
public interface ApkVersionDao extends SuperMapper<ApkVersion> {
    default ApkVersion getLastVersion() {
        return selectLimitOne(Wrappers.lambdaQuery(ApkVersion.class).orderByDesc(ApkVersion::getCreateTime));
    }

    default ApkVersion getLastVersion(String version) {
        return selectLimitOne(Wrappers.lambdaQuery(ApkVersion.class).eq(ApkVersion::getApkVersion, version).orderByDesc(ApkVersion::getCreateTime));
    }
}
