/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.cloudcenter.domain.response.p2c;

import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.cloudcenter.domain.request.p2c.P2rBaseRequest;
import com.icetech.common.annotation.NotNull;
import java.io.Serializable;

public class P2rBaseResponse<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private String messageId;
    @NotNull
    private String token;
    @NotNull
    private Integer code;
    private String msg;
    private T data;

    public static <T> P2rBaseResponse<T> success(P2rBaseRequest<?> request, T data) {
        P2rBaseResponse<T> response = P2rBaseResponse.success(request);
        response.setData(data);
        return response;
    }

    public static <T> P2rBaseResponse<T> success(P2rBaseRequest<?> request) {
        return P2rBaseResponse.instance(request, CodeEnum.\u6210\u529f.getCode());
    }

    public static <T> P2rBaseResponse<T> instance(P2rBaseRequest<?> request, int code) {
        return P2rBaseResponse.instance(request, code, CodeEnum.getMsg(code));
    }

    public static <T> P2rBaseResponse<T> instance(P2rBaseRequest<?> request, int code, String msg) {
        P2rBaseResponse<T> response = new P2rBaseResponse<T>();
        response.setToken(request.getToken());
        response.setMessageId(request.getMessageId());
        response.setCode(code);
        response.setMsg(CodeEnum.getMsg(code) + "," + msg);
        return response;
    }

    public String toString() {
        return "P2rBaseResponse(messageId=" + this.getMessageId() + ", token=" + this.getToken() + ", code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getToken() {
        return this.token;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }
}

