/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.cloudcenter.domain.response.p2c;

import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.common.domain.request.P2cBaseRequest;
import java.io.Serializable;

public class P2cBaseResponse<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CMD_SUFFIX = "_resp";
    private String cmd;
    private String messageId;
    private String token;
    private Integer code;
    private String msg;
    private String resultPath;
    private T data;

    public static <T> P2cBaseResponse<T> success(P2cBaseRequest<?> request, T data) {
        P2cBaseResponse<T> response = P2cBaseResponse.success(request);
        response.setData(data);
        return response;
    }

    public static <T> P2cBaseResponse<T> success(P2cBaseRequest<?> request) {
        return P2cBaseResponse.instance(request, CodeEnum.\u6210\u529f.getCode());
    }

    public static <T> P2cBaseResponse<T> instance(P2cBaseRequest<?> request, int code) {
        return P2cBaseResponse.instance(request, code, CodeEnum.getMsg(code));
    }

    public static <T> P2cBaseResponse<T> instance(P2cBaseRequest<?> request, int code, String msg) {
        P2cBaseResponse<T> response = new P2cBaseResponse<T>();
        response.setToken(request.getToken());
        if (request.getCmd() != null) {
            response.setCmd(request.getCmd() + CMD_SUFFIX);
        }
        response.setMessageId(request.getMessageId());
        response.setCode(code);
        response.setMsg(msg);
        return response;
    }

    public static <T> P2cBaseResponse<T> instance(int code, String msg) {
        P2cBaseResponse<T> response = new P2cBaseResponse<T>();
        response.setCode(code);
        response.setMsg(msg);
        return response;
    }

    public static <T> P2cBaseResponse<T> instance(CodeEnum code) {
        P2cBaseResponse<T> response = new P2cBaseResponse<T>();
        response.setCode(code.getCode());
        response.setMsg(code.getMsg());
        return response;
    }

    public String getCmd() {
        return this.cmd;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getToken() {
        return this.token;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getResultPath() {
        return this.resultPath;
    }

    public T getData() {
        return this.data;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setResultPath(String resultPath) {
        this.resultPath = resultPath;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return "P2cBaseResponse(cmd=" + this.getCmd() + ", messageId=" + this.getMessageId() + ", token=" + this.getToken() + ", code=" + this.getCode() + ", msg=" + this.getMsg() + ", resultPath=" + this.getResultPath() + ", data=" + this.getData() + ")";
    }
}

