/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.cloudcenter.domain.response;

import com.icetech.cloudcenter.domain.response.NotPayDetail;
import com.icetech.cloudcenter.domain.response.QueryFeeRegionDetail;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class QueryOrderFeeResponse
implements Serializable {
    protected String orderNum;
    protected String localOrderNum;
    protected String plateNum;
    protected String totalAmount;
    protected String paidAmount;
    protected String discountAmount;
    protected String discountPrice;
    protected String unpayPrice;
    private String vipDiscountPrice;
    private String thirdDiscountPrice;
    private String merchantDiscountPrice;
    protected Long parkTime;
    protected Long payTime;
    protected Long queryTime;
    protected List<QueryFeeRegionDetail> insideDetails;
    private Integer status;
    private Long enterTime;
    private String parkName;
    private Long freeTime;
    private Integer carType;
    private Boolean isFixedFee;
    private String tradeNo;
    private Boolean isOffline;
    private Boolean hasInnerAreaFee;
    private String sumPrice;
    private String totalNotPayPrice;
    private List<NotPayDetail> notPayDetails;

    public String getSumPrice() {
        if (this.sumPrice != null) {
            return this.sumPrice;
        }
        if (this.unpayPrice != null && this.totalNotPayPrice != null) {
            this.sumPrice = new BigDecimal(this.unpayPrice).add(new BigDecimal(this.totalNotPayPrice)).toString();
        } else if (this.unpayPrice != null) {
            this.sumPrice = this.unpayPrice;
        } else if (this.totalNotPayPrice != null) {
            this.sumPrice = this.totalNotPayPrice;
        }
        return this.sumPrice;
    }

    public Integer getStatus() {
        if (this.status != null && this.status == 1 && NumberUtils.parseDouble((Object)this.getSumPrice()) > 0.0) {
            this.status = 2;
        }
        return this.status;
    }

    public boolean removeNotPayItem(String orderNum) {
        if (CollectionUtils.isEmpty(this.notPayDetails) || StringUtils.isBlank((CharSequence)orderNum)) {
            return false;
        }
        boolean ret = this.notPayDetails.removeIf(notPayDetail -> notPayDetail.getOrderNum().equals(orderNum));
        if (ret) {
            double totalNotPayPrice = this.notPayDetails.stream().mapToDouble(notPayDetail -> NumberUtils.parseDouble((Object)notPayDetail.getUnPayPrice())).sum();
            this.totalNotPayPrice = String.valueOf(totalNotPayPrice);
            this.sumPrice = String.valueOf(totalNotPayPrice + (this.unpayPrice == null ? 0.0 : NumberUtils.parseDouble((Object)this.unpayPrice)));
        }
        return ret;
    }

    public static QueryOrderFeeResponse buildEmptyOrderFee(String plateNum, String parkName, Integer freeAfterPay, Integer carType, String orderNum) {
        QueryOrderFeeResponse queryOrderFeeResponse = new QueryOrderFeeResponse();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orderNum)) {
            queryOrderFeeResponse.setOrderNum(orderNum);
        } else {
            queryOrderFeeResponse.setOrderNum("E" + CodeTools.GenerateOrderNum());
        }
        queryOrderFeeResponse.setParkName(parkName);
        queryOrderFeeResponse.setPlateNum(plateNum);
        queryOrderFeeResponse.setEnterTime(DateTools.unixTimestamp());
        queryOrderFeeResponse.setCarType(carType);
        queryOrderFeeResponse.setQueryTime(DateTools.unixTimestamp());
        queryOrderFeeResponse.setParkTime(0L);
        queryOrderFeeResponse.setTotalAmount(String.valueOf(0));
        queryOrderFeeResponse.setUnpayPrice(String.valueOf(0));
        queryOrderFeeResponse.setPaidAmount(String.valueOf(0));
        queryOrderFeeResponse.setDiscountAmount(String.valueOf(0));
        queryOrderFeeResponse.setDiscountPrice(String.valueOf(0));
        queryOrderFeeResponse.setStatus(1);
        queryOrderFeeResponse.setFreeTime((long)freeAfterPay);
        return queryOrderFeeResponse;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public void setLocalOrderNum(String localOrderNum) {
        this.localOrderNum = localOrderNum;
    }

    public void setPlateNum(String plateNum) {
        this.plateNum = plateNum;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public void setPaidAmount(String paidAmount) {
        this.paidAmount = paidAmount;
    }

    public void setDiscountAmount(String discountAmount) {
        this.discountAmount = discountAmount;
    }

    public void setDiscountPrice(String discountPrice) {
        this.discountPrice = discountPrice;
    }

    public void setUnpayPrice(String unpayPrice) {
        this.unpayPrice = unpayPrice;
    }

    public void setVipDiscountPrice(String vipDiscountPrice) {
        this.vipDiscountPrice = vipDiscountPrice;
    }

    public void setThirdDiscountPrice(String thirdDiscountPrice) {
        this.thirdDiscountPrice = thirdDiscountPrice;
    }

    public void setMerchantDiscountPrice(String merchantDiscountPrice) {
        this.merchantDiscountPrice = merchantDiscountPrice;
    }

    public void setParkTime(Long parkTime) {
        this.parkTime = parkTime;
    }

    public void setPayTime(Long payTime) {
        this.payTime = payTime;
    }

    public void setQueryTime(Long queryTime) {
        this.queryTime = queryTime;
    }

    public void setInsideDetails(List<QueryFeeRegionDetail> insideDetails) {
        this.insideDetails = insideDetails;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setEnterTime(Long enterTime) {
        this.enterTime = enterTime;
    }

    public void setParkName(String parkName) {
        this.parkName = parkName;
    }

    public void setFreeTime(Long freeTime) {
        this.freeTime = freeTime;
    }

    public void setCarType(Integer carType) {
        this.carType = carType;
    }

    public void setIsFixedFee(Boolean isFixedFee) {
        this.isFixedFee = isFixedFee;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public void setIsOffline(Boolean isOffline) {
        this.isOffline = isOffline;
    }

    public void setHasInnerAreaFee(Boolean hasInnerAreaFee) {
        this.hasInnerAreaFee = hasInnerAreaFee;
    }

    public void setSumPrice(String sumPrice) {
        this.sumPrice = sumPrice;
    }

    public void setTotalNotPayPrice(String totalNotPayPrice) {
        this.totalNotPayPrice = totalNotPayPrice;
    }

    public void setNotPayDetails(List<NotPayDetail> notPayDetails) {
        this.notPayDetails = notPayDetails;
    }

    public String getOrderNum() {
        return this.orderNum;
    }

    public String getLocalOrderNum() {
        return this.localOrderNum;
    }

    public String getPlateNum() {
        return this.plateNum;
    }

    public String getTotalAmount() {
        return this.totalAmount;
    }

    public String getPaidAmount() {
        return this.paidAmount;
    }

    public String getDiscountAmount() {
        return this.discountAmount;
    }

    public String getDiscountPrice() {
        return this.discountPrice;
    }

    public String getUnpayPrice() {
        return this.unpayPrice;
    }

    public String getVipDiscountPrice() {
        return this.vipDiscountPrice;
    }

    public String getThirdDiscountPrice() {
        return this.thirdDiscountPrice;
    }

    public String getMerchantDiscountPrice() {
        return this.merchantDiscountPrice;
    }

    public Long getParkTime() {
        return this.parkTime;
    }

    public Long getPayTime() {
        return this.payTime;
    }

    public Long getQueryTime() {
        return this.queryTime;
    }

    public List<QueryFeeRegionDetail> getInsideDetails() {
        return this.insideDetails;
    }

    public Long getEnterTime() {
        return this.enterTime;
    }

    public String getParkName() {
        return this.parkName;
    }

    public Long getFreeTime() {
        return this.freeTime;
    }

    public Integer getCarType() {
        return this.carType;
    }

    public Boolean getIsFixedFee() {
        return this.isFixedFee;
    }

    public String getTradeNo() {
        return this.tradeNo;
    }

    public Boolean getIsOffline() {
        return this.isOffline;
    }

    public Boolean getHasInnerAreaFee() {
        return this.hasInnerAreaFee;
    }

    public String getTotalNotPayPrice() {
        return this.totalNotPayPrice;
    }

    public List<NotPayDetail> getNotPayDetails() {
        return this.notPayDetails;
    }

    public String toString() {
        return "QueryOrderFeeResponse(orderNum=" + this.getOrderNum() + ", localOrderNum=" + this.getLocalOrderNum() + ", plateNum=" + this.getPlateNum() + ", totalAmount=" + this.getTotalAmount() + ", paidAmount=" + this.getPaidAmount() + ", discountAmount=" + this.getDiscountAmount() + ", discountPrice=" + this.getDiscountPrice() + ", unpayPrice=" + this.getUnpayPrice() + ", vipDiscountPrice=" + this.getVipDiscountPrice() + ", thirdDiscountPrice=" + this.getThirdDiscountPrice() + ", merchantDiscountPrice=" + this.getMerchantDiscountPrice() + ", parkTime=" + this.getParkTime() + ", payTime=" + this.getPayTime() + ", queryTime=" + this.getQueryTime() + ", insideDetails=" + this.getInsideDetails() + ", status=" + this.getStatus() + ", enterTime=" + this.getEnterTime() + ", parkName=" + this.getParkName() + ", freeTime=" + this.getFreeTime() + ", carType=" + this.getCarType() + ", isFixedFee=" + this.getIsFixedFee() + ", tradeNo=" + this.getTradeNo() + ", isOffline=" + this.getIsOffline() + ", hasInnerAreaFee=" + this.getHasInnerAreaFee() + ", sumPrice=" + this.getSumPrice() + ", totalNotPayPrice=" + this.getTotalNotPayPrice() + ", notPayDetails=" + this.getNotPayDetails() + ")";
    }
}

