/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.cloudcenter.domain.request.p2r;

import com.icetech.cloudcenter.domain.constants.SayElementConstants;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;

public class RobotHintRequest
implements Serializable {
    private String plateNum;
    private String say;
    private String show;

    public void setShow(String show) {
        if (StringUtils.isNotBlank((CharSequence)show)) {
            String[] splitArr;
            if (show.endsWith("/")) {
                show = show + " ";
            }
            if ((splitArr = show.split("/")).length == 1) {
                show = show + "/ / / ";
            } else if (splitArr.length == 2) {
                show = show + "/ / ";
            } else if (splitArr.length == 3) {
                show = show + "/ ";
            }
            show = show.replace("//", "/ /");
        }
        this.show = show;
    }

    public void setSay(String say) {
        if (StringUtils.isNotBlank((CharSequence)say) && say.contains("<")) {
            String content = say.trim();
            StringBuffer sayStrBuf = new StringBuffer();
            int fromIndex = 0;
            int start = content.indexOf("<", fromIndex);
            while (start >= 0) {
                String template;
                int end = content.indexOf(">", start);
                String elementName = content.substring(start + 1, end);
                fromIndex = end;
                if (elementName.trim().length() > 0 && (template = SayElementConstants.SAY_ELEMENT.get(elementName.replace("/", ""))) != null && !elementName.startsWith("/")) {
                    if (elementName.endsWith("/")) {
                        sayStrBuf.append(template);
                    } else {
                        int start2 = content.indexOf("<", fromIndex);
                        fromIndex = start2 + 1;
                        String val = content.substring(end + 1, start2);
                        if (elementName.equals("D8")) {
                            val = "1".equals(val) ? "\u5c0f\u578b\u8f66" : "\u5927\u578b\u8f66";
                        } else if (elementName.equals("D6") || elementName.equals("7")) {
                            val = DateTools.secondToSecondsTime((int)Integer.parseInt(val));
                        } else if (elementName.equals("D7") || elementName.equals("8")) {
                            val = new BigDecimal(val).divide(new BigDecimal(10)).setScale(2, 5).toString();
                        }
                        sayStrBuf.append(template.replace("%", val));
                    }
                }
                start = content.indexOf("<", fromIndex);
                sayStrBuf.append(" ");
            }
            this.say = sayStrBuf.toString().trim();
        } else {
            this.say = say;
        }
    }

    public String getPlateNum() {
        return this.plateNum;
    }

    public String getSay() {
        return this.say;
    }

    public String getShow() {
        return this.show;
    }

    public void setPlateNum(String plateNum) {
        this.plateNum = plateNum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RobotHintRequest)) {
            return false;
        }
        RobotHintRequest other = (RobotHintRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$plateNum = this.getPlateNum();
        String other$plateNum = other.getPlateNum();
        if (this$plateNum == null ? other$plateNum != null : !this$plateNum.equals(other$plateNum)) {
            return false;
        }
        String this$say = this.getSay();
        String other$say = other.getSay();
        if (this$say == null ? other$say != null : !this$say.equals(other$say)) {
            return false;
        }
        String this$show = this.getShow();
        String other$show = other.getShow();
        return !(this$show == null ? other$show != null : !this$show.equals(other$show));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RobotHintRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $plateNum = this.getPlateNum();
        result = result * 59 + ($plateNum == null ? 43 : $plateNum.hashCode());
        String $say = this.getSay();
        result = result * 59 + ($say == null ? 43 : $say.hashCode());
        String $show = this.getShow();
        result = result * 59 + ($show == null ? 43 : $show.hashCode());
        return result;
    }

    public String toString() {
        return "RobotHintRequest(plateNum=" + this.getPlateNum() + ", say=" + this.getSay() + ", show=" + this.getShow() + ")";
    }
}

