/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.cloudcenter.domain.enumeration;

import com.icetech.common.utils.StringUtils;

public enum P2cVersionEnum {
    \u7248\u672c1("1.0", 1),
    \u7248\u672c2("1.1", 2),
    \u7248\u672c3("1.2", 3),
    \u7248\u672c4("1.3", 4),
    \u7248\u672c5("1.3.4", 5),
    \u7248\u672c6("1.3.5", 6),
    \u7248\u672c7("1.3.6", 7),
    \u7248\u672c8("1.4", 8),
    \u7248\u672c9("1.5", 9),
    \u7248\u672c10("1.5.1", 10),
    \u7248\u672c11("1.5.2", 11),
    \u7248\u672c12("1.5.3", 12),
    \u7248\u672c13("1.5.4", 13),
    \u7248\u672c14("1.5.5", 14),
    \u7248\u672c15("1.5.6", 15),
    \u7248\u672c16("1.5.7", 16),
    \u7248\u672c17("2.0.0", 17),
    \u7248\u672c18("2.1.0", 18),
    \u7248\u672c19("2.1.1", 19),
    \u7248\u672c20("2.1.2", 20),
    \u7248\u672c21("2.1.3", 21),
    \u7248\u672c22("2.1.4", 22);

    private String version;
    private int index;

    private P2cVersionEnum(String version, int index) {
        this.version = version;
        this.index = index;
    }

    public static int getIndex(String version) {
        if (version == null) {
            return 0;
        }
        for (P2cVersionEnum p2cVersionEnum : P2cVersionEnum.values()) {
            if (!p2cVersionEnum.version.equals(version)) continue;
            return p2cVersionEnum.index;
        }
        return 0;
    }

    public static float getNumber(String version) {
        if (StringUtils.isBlank((CharSequence)version)) {
            return 0.0f;
        }
        String[] split = version.split("\\.");
        if (split.length == 1) {
            return 0.0f;
        }
        String newVer = split[0] + ".";
        for (int i = 1; i < split.length; ++i) {
            String node = split[i];
            String tempNode = node.length() == 1 ? "0" + node : node;
            newVer = newVer + tempNode;
        }
        return Float.parseFloat(newVer);
    }

    public String getVersion() {
        return this.version;
    }

    public int getIndex() {
        return this.index;
    }
}

