/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.cloudcenter.domain;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class PageResult<T>
implements Serializable {
    protected Integer pageNo = 1;
    protected Integer pageNum = 1;
    protected Integer pageIndex = 1;
    protected Integer pageSize = 10;
    protected Integer totalPages = 0;
    protected Long totalCount = 0L;
    protected List<T> dataList;

    public PageResult(com.github.pagehelper.Page<T> page) {
        this.fromPage(page, page.getResult());
    }

    public PageResult(com.github.pagehelper.Page<?> page, List<T> dataList) {
        this.fromPage(page, dataList);
    }

    public void fromPage(com.github.pagehelper.Page<T> page) {
        this.fromPage(page, page.getResult());
    }

    public void fromPage(com.github.pagehelper.Page<?> page, List<T> dataList) {
        this.setPageNo(page.getPageNum());
        this.setPageNum(page.getPageNum());
        this.setPageIndex(page.getPageNum());
        this.setPageSize(page.getPageSize());
        this.setTotalPages(page.getPages());
        this.setTotalCount(page.getTotal());
        this.setDataList(dataList);
    }

    public static <T> PageResult<T> fromPages(com.github.pagehelper.Page<T> page) {
        return new PageResult<T>(page);
    }

    public static <T> PageResult<T> fromPage(Page<T> page) {
        PageResult<T> result = new PageResult<T>();
        result.setPageNo((int)page.getCurrent());
        result.setPageNum((int)page.getCurrent());
        result.setPageIndex((int)page.getCurrent());
        result.setPageSize((int)page.getSize());
        result.setTotalPages((int)page.getPages());
        result.setTotalCount(page.getTotal());
        result.setDataList(page.getRecords());
        return result;
    }

    public com.icetech.common.domain.Page<T> toCommonPage() {
        return new com.icetech.common.domain.Page(this.totalCount, this.totalPages, this.dataList);
    }

    public static <T> PageResult<T> empty() {
        PageResult result = new PageResult();
        result.setDataList(Collections.emptyList());
        return result;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Integer getTotalPages() {
        return this.totalPages;
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public List<T> getDataList() {
        return this.dataList;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotalPages(Integer totalPages) {
        this.totalPages = totalPages;
    }

    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    public void setDataList(List<T> dataList) {
        this.dataList = dataList;
    }

    public String toString() {
        return "PageResult(pageNo=" + this.getPageNo() + ", pageNum=" + this.getPageNum() + ", pageIndex=" + this.getPageIndex() + ", pageSize=" + this.getPageSize() + ", totalPages=" + this.getTotalPages() + ", totalCount=" + this.getTotalCount() + ", dataList=" + this.getDataList() + ")";
    }

    public PageResult() {
    }
}

