package com.icetech.cloudcenter.rpc.api.order;

import java.time.LocalDate;
import java.util.List;

import com.icetech.cloudcenter.domain.response.ParkEnterOrexitCountDto;

public interface OrderEnexCountApi {
    /**
     * 获取指定日期每小时出入数量统计
     * @param parkId 车场ID
     * @param countDate 时间, 可为空, 为空则为本日
     */
    List<ParkEnterOrexitCountDto> selectCountsByDate(Long parkId, LocalDate countDate);

    List<ParkEnterOrexitCountDto> selectCountsByTimeRange(Long parkId, long startSecs, long endSecs);
}
