package com.icetech.cloudcenter.domain.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * Description 车牌复审
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2021/7/19 5:43 下午
 */
@Data
public class PlateRecheckVo implements Serializable {

    /**
     * 订单号
     */
    private String orderNum;
    
    /**
     * 车场id
     */
    private Integer parkId;
    
    /**
     * 车场编号
     */
    private String parkCode;

    /**
     * 车场名称
     */
    private String parkName;

    /**
     * 通道编码
     */
    private String channelCode;

    /**
     * 出入口类型，1入口 2出口
     */
    private Integer inandoutType;

    /**
     * 入场时间
     */
    private Date enterTime;

    /**
     * 图片
     */
    private String image;

    /**
     *  进场小图片
     */
    private String smallEnterImage;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 识别车牌号
     */
    private String plateNumIot;

    /**
     * 数据上报方式:1端云;2端网云;3纯云
     */
    private Integer dataCollection;
    
    
}
