package com.icetech.cloudcenter.domain.response.p2c;

import java.io.Serializable;

import com.icetech.cloudcenter.domain.enumeration.CodeEnum;
import com.icetech.common.domain.request.P2cBaseRequest;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 端云架构基础参数类
 *
 * @param <T>
 */
@Getter
@Setter
@ToString
public class P2cBaseResponse<T> implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 返回参数中cmd的后缀
     */
    public static final String CMD_SUFFIX = "_resp";

    private String cmd;
    private String messageId;
    private String token;
    private Integer code;
    private String msg;
    /**
     * 上报路径
     */
    private String resultPath;
    private T data;

    public static <T> P2cBaseResponse<T> success(P2cBaseRequest<?> request, T data) {
        P2cBaseResponse<T> response = success(request);
        response.setData(data);
        return response;
    }

    /**
     * 返回正确的结果
     *
     * @param request
     * @return
     */
    public static <T> P2cBaseResponse<T> success(P2cBaseRequest<?> request) {
        return instance(request, CodeEnum.成功.getCode());
    }

    /**
     * 返回正确的结果
     *
     * @param request
     * @return
     */
    public static <T> P2cBaseResponse<T> instance(P2cBaseRequest<?> request, int code) {
        return instance(request, code, CodeEnum.getMsg(code));
    }

    /**
     * 返回正确的结果
     *
     * @param request
     * @return
     */
    public static <T> P2cBaseResponse<T> instance(P2cBaseRequest<?> request, int code, String msg) {
        P2cBaseResponse<T> response = new P2cBaseResponse<>();
        response.setToken(request.getToken());
        if (request.getCmd() != null) {
            response.setCmd(request.getCmd() + CMD_SUFFIX);
        }
        response.setMessageId(request.getMessageId());
        response.setCode(code);
        response.setMsg(msg);
        return response;
    }

    public static <T> P2cBaseResponse<T> instance(int code, String msg) {
        P2cBaseResponse<T> response = new P2cBaseResponse<>();
        response.setCode(code);
        response.setMsg(msg);
        return response;
    }

    public static <T> P2cBaseResponse<T> instance(CodeEnum code) {
        P2cBaseResponse<T> response = new P2cBaseResponse<>();
        response.setCode(code.getCode());
        response.setMsg(code.getMsg());
        return response;
    }
}
