package com.icetech.cloudcenter.domain.response;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 拉取费用响应
 */
@Data
public class PullfeeResponse implements Serializable {
    /**
     *总应收
     */
    private String totalPrice;
    /**
     *实收(已经缴费金额)
     */
    private String paidPrice;
    /**
     *总优惠
     */
    private String discountPrice;
    /**
     * 本次优惠
     */
    private String currentDiscountPrice;
    /**
     *需支付
     */
    private String needPayPrice;
    /**
     * 查询时间
     */
    private Long queryTime;
    /**
     * 上次支付时间
     */
    private Long lastPayTime;
    /**
     * 交易流水号，source为1时必传
     */
    private String tradeNo;
    private String orderNum;

    /** 内区域计费信息 **/
    protected List<QueryFeeRegionDetail> insideDetails;
}
