package com.icetech.cloudcenter.domain.response;

import com.icetech.order.domain.entity.OrderNotpay;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 欠费订单
 * @author fangct
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Accessors(chain = true)
public class NotPayDetail implements Serializable {
    protected Long parkId;
    protected String parkCode;
    /**
     * 本地订单号
     */
    protected String orderId;

    protected String orderNum;
    protected String tradeNo;
    /** 应付金额 */
    protected String totalPrice;
    /** 优惠金额 */
    protected String discountPrice;
    /** 欠费缴费金额，totalPrice = discountPrice + unPayPrice */
    protected String unPayPrice;
    /** 入场时间 */
    private Long enterTime;
    /** 离场时间 */
    protected Long exitTime;
    /** 停车总时长，单位秒 */
    protected Long parkTime;

    /** @see com.icetech.order.domain.entity.OrderNotpay#getOrderSource */
    protected Integer orderSource = OrderNotpay.ORDER_SOURCE_PARK;

    public boolean isParkOrder() {
        return OrderNotpay.ORDER_SOURCE_PARK.equals(orderSource);
    }
}
