package com.icetech.cloudcenter.domain.response;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author wanggang
 * @create 2025-01-22 14:18
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class MonthOrderResponseVo implements Serializable {
    /**
     * 月卡套餐名称
     */
    private String productName;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 有效开始时间
     */
    private Date useBeginDate;

    /**
     * 有效结束时间
     */
    private Date useEndDate;

    /**
     * 车场名称
     */
    private String parkName;

    /**
     * 适用规则
     */
    private String userChareg;

    /**
     * 购买时间
     */
    private Date payTime;

    /**
     * 月卡状态
     */
    private Integer cardStatus;

    /**
     * 购买方式
     */
    private Integer payChannel;

    /**
     * 支付金额
     */
    private BigDecimal payAmount;

    /**
     * 月卡ID
     */
    private Long productId;

    private BigDecimal deposit;

    /**
     * 是否需要有押金 默认0,0否，1是',
     */
    private Integer isHaveDeposit;
}
