package com.icetech.cloudcenter.domain.response;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 月卡信息
 * @author wangzw
 */
@Data
public class MonthInfoDto implements Serializable {

    /**
     * 月卡的id
     */
    private Integer id;
    /**
     * 车场id
     */
    private Long parkId;
    /**
     * 车场编码
     */
    private String parkCode = "";
    /**
     * 车场名称
     */
    private String parkName = "";
    /**
     * 月卡所属人姓名/公司名称
     */
    private String cardOwner;
    /**
     * 车牌号(多个用,隔开)
     */
    private String plateNumber;
    /**
     * 车位数
     */
    private int plotCount;
    /**
     * 月卡有效开始日期
     */
    private Date startTime;
    /**
     * 月卡有效结束日期
     */
    private Date endTime;
    /**
     * 月卡状态 1 生效中 2 待生效 3 已退费 4 已过期 5 冻结 6暂停 98 审核中 99 已驳回
     */
    private int status;
    /**
     * 修改时间
     */
    private Date updateTime;
    /**
     * 月卡产品
     */
    private String productName;

    /**
     * 月卡产品id
     */
    private Long productId;

    /**
     * 车位数量
     */
    private String plotNum;

    /**
     * 联系方式
     */
    private String phone;
    /**
     * 申办性质
     */
    private Integer cardProperty;
    /**
     * 1 未审核 2 已审核 3 驳回
     */
    private Integer cardOpertype;
    /**
     * 所属区域
     */
    private String regionName;
    /**
     * 默认续费套餐 购买渠道 0：仅平台可购买 1：平台和公众号均可购买
     */
    private Integer buyChannel;
    /**
     * 默认续费套餐 公众号开卡 0：不允许 1：允许
     */
    private Integer accountSales;
    /**
     * 是否支持公众号续费 -1=限制 0代表不限制 公众号过期X天内可续费，最大365
     */
    private Integer renewLimitDay;
}
