package com.icetech.cloudcenter.domain.response;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author wangzw
 */
@Data
public class MerchantDiscountDto implements Serializable {
    /**
     * id
     */
    private Integer id;

    /**
     * 停车场id
     */
    private Long parkId;
    /**
     * 车厂名称
     */
    private String parkName;
    /**
     * 商户id
     */
    private int merchantId;

    /**
     * 模板编号
     */
    private String code;

    /**
     * 优惠券名称
     */
    private String name;

    /**
     * 优惠类型1全免2减免时间3减免金额4折扣
     */
    private int type;

    /**
     * 优惠数额
     */
    private String amount;

    /**
     * 商家扣除余额类型：优惠类型为1时，1：按时长计费后扣除，2按金额(元)扣除；当优惠类型为4时，1：按计费折算后扣除，2按金额(元)扣除；\r\n商家扣除余额类型：优惠类型为1时，1：按时长计费后扣除，2按金额(元)扣除；当优惠类型为4时，1：按计费折算后扣除，2按金额(元)扣除；
     */
    private int deductType;

    /**
     *
     */
    private BigDecimal deductMoney;

    /**
     * 有效期开始时间
     */
    private Date startTime;

    /**
     * 有效期结束时间
     */
    private Date endTime;

    /**
     * 是否默认选中 默认 false
     */
    private Boolean checked = false;
    /**
     * 单位
     */
    private String units = "元";
    /**
     * 最大天数
     */
    private Integer amountDay;

    /**
     * 优惠码有效时长(分)
     */
    private Integer discodeTimelong;

    /**
     * 系统自动添加 0不支持，1支持
     */
    private Integer isQrcode;

    /**
     * 静态码领取时限 1=限时 0=不限时
     */
    private Integer isLimitTime;


    /**
     * 静态码领取限制时长
     */
    private Integer limitTime;

}
