package com.icetech.cloudcenter.domain.response;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class EnterCarDto implements Serializable {
    private Long id;
    private Long regionId;
    /**
     * 入场时间
     */
    private Date enterTime;
    /**
     * 车牌号
     */
    private String plateNumber;
    /**
     * 车辆类型
     */
    private Integer type;
    /**
     * 停车时长
     */
    private Long parkTime;
    private String parkTimeStr;

    /**
     * 车型
     */
    private Integer carType;

    /**
     * 入口名称
     */
    private String enterName;

    /**
     * url
     */
    private String imgUrl;

    private String orderNum;
    private String parkName;
    /**
     * 订单车牌置信度
     */
    private Integer reliability = 0;

    /**
     * 入场方式 1车牌识别入场，2遥控器抬杆入场，3无牌车扫码入场，4软件人工入场
     */
    private Integer enterWay;
    /**
     * 是否有子订单
     */
    private Integer hasSon;
    /**
     * 备注
     */
    private String remark;
    /**
     * 出场方式：1车牌识别，2遥控器抬杆，3无牌车扫码，4软件人工，5断电应急
     */
    private Integer exitWay;

    /**
     * 软件人工入场的操作人账号
     */
    private String enterOperAccount;
    /**
     * 软件人工离场的操作人账号
     */
    private String exitOperAccount;

    /**
     * 入场终端，1 云坐席、2 车场帮APP 、3 云岗亭、4岗亭计费软件、5 车场监控'
     */
    private Integer enterTerminal;

    /**
     * 离场终端，1 云坐席、2 车场帮APP 、3 云岗亭、4岗亭计费软件、5 车场监控'
     */
    private Integer exitTerminal;


    /**
     * 订单标签，1：多位多车占用，2：使用该车上一次的入场时间计费，3：欠费车辆，4：折返回场，5：虚假车牌，6：补缴车辆
     */
    private List<Integer> orderTag;

    /**
     * 无入场记录标识(0=否;1=是)
     */
    private Integer noneEnterFlag;
}
