package com.icetech.cloudcenter.domain.response;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class    ChannelAlarmDto implements Serializable {
    private static final long serialVersionUID = 1L;


    /**
     * 滞留车辆列表
     */
    private Long parkId;
    
    /**
     * 车场名称
     */
    private String  parkName;

    /**
     * 车场编码
     */
    private String parkCode;

    /**
     * 设备序列号
     */
    private String serialNumber;

    /**
     * 通道编号
     */
    private String aisleCode;
    /**
     * 通道名称
     */
    private String aisleName;
    /**
     * 通道类型
     */
    private int aisleType;
    /**
     * 报警类型(1查询费用失败，2缴费未抬杆)
     */
    private Integer alarmType;

    /**
     * 描述
     */
    private String remark;

    /**
     * 通道图片
     */
    private String image;

    private String videoUrl;
    private String voiceDeviceId;
    /**
     * 华夏监控相机视频地址
     */
    private String iceMorVideoUrl;
    /**
     * 华夏监控相机SN
     */
    private String iceMorSn;
    /**
     * 设备IP，可能为空
     */
    private String ip;
    /**
     * 设备端口，可能为空
     */
    private String port;

    /**
     * 是否支持通话，1： 支持
     */
    private Integer isCall;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 云翌 号码
     */
    private String yuneasyNumber;

    /**
     * 托管状态,0-未开通， 1-未生效，2-托管中，3-托管到期
     */
    private Integer trusteeshipStatus;

    /**
     * 托管有效结束日期
     */
    private Date trusteeshipEndTime;

    /**
     * 数据上报方式:1端云;2端网云;3纯云
     */
    private Integer dataCollection;
}
