package com.icetech.cloudcenter.domain.request.pnc;

import lombok.Data;

/**
 * 储值卡车辆信息下发
 */
@Data
public class StoreCardRequest {
    public static final String DATE_PATTERN = "yyyy-MM-dd";

    /**
     * 操作类型1=添加 2=修改 3=删除
     */
    protected Integer operType;
    /**
     * 操作时间（unix时间戳）
     */
    protected Long operTime;
    /**
     * 储值卡ID
     */
    protected Long cardId;
    /**
     * 储值卡编号
     */
    protected String cardNum;
    /**
     * 车主姓名
     */
    protected String owner;
    /**
     * 车主电话
     */
    protected String phone;
    /**
     * 车主地址
     */
    protected String address;
    /**
     * 有效期开始日期，格式为yyyy-MM-dd
     */
    protected String startDate;
    /**
     * 有效期结束日期，格式为yyyy-MM-dd
     */
    protected String endDate;
    /**
     * 可用余额
     */
    protected String balance;
    /**
     * 车牌号,可以多个。会以"/"连接。
     */
    protected String plateNums;
}
