package com.icetech.cloudcenter.domain.request.pnc;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;

/**
 * 机器人支付信息展示接口bizContent请求参数
 */
@Setter
@Getter
public class RobotShowPayInfoRequest {

    /** 管道ID, 管道=机器人序列号的部分组成 */
    @NotNull
    private String channelId;

    /** 订单号 */
    @NotNull
    private String orderId;

    /** 中间的二维码URL */
    @NotNull
    private String qrCodeUrl;

    /** 二维码上方提示信息 */
    @NotNull
    private String noticeMsg;

    /** 其他显示内容，包括四部分：车牌号、缴费金额、停车时长、车辆类型(临时车、月卡车、特殊车辆、VIP车辆和预约车) ；
     * 每部分中间用斜杠隔开。
     * 例：临A0001/5.00元/1小时02分钟/临时车
     */
    @NotNull
    private String show;

}
