package com.icetech.cloudcenter.domain.request.pnc;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;

/**
 * 机器人语音屏显接口bizContent请求参数
 */
@Setter
@Getter
public class RobotSayShowRequest {

    /** 管道ID, 管道=机器人序列号的部分组成 */
    @NotNull
    private String channelId;

    /** 车牌号，可能会是空串"" */
    @NotNull
    private String plateNum;

    /** 语音信息，数字内容会按照个十百千万位播报（888，播报八百八十八），
     * 不需要加单位可在数字中间加空格即可（8 8 8，播报八八八），可能会是空串""
     */
    @NotNull
    private String say;

    /**
     * 屏显信息，屏显内容分三部分，每部分中间用斜杠隔开；
     * 例：智芯停车欢迎您/车牌号/车辆类型（临时车、月卡车、特殊车辆、VIP车、访客车），可能会是空串""
     */
    @NotNull
    private String show;

}
