package com.icetech.cloudcenter.domain.request.pnc;

import com.icetech.common.annotation.NotNull;

import java.util.List;

public class ParkStatusRequest {

    @NotNull
    private Long localTime;
    private String channelId;
    private Integer emptyNumber;
    /**
     * 协议类型
     * 1-WebSocket
     * 2-MQTT
     */
    private Integer protocol;

    /**
     * 多区域车场，所有区域剩余车位数，非多区域车场无需上传
     */
    private List<RegionParkInfoRequest> regionParkInfo;

    public List<RegionParkInfoRequest> getRegionParkInfo() {
        return regionParkInfo;
    }

    public void setRegionParkInfo(List<RegionParkInfoRequest> regionParkInfo) {
        this.regionParkInfo = regionParkInfo;
    }

    public Long getLocalTime() {
        return localTime;
    }

    public void setLocalTime(Long localTime) {
        this.localTime = localTime;
    }

    public String getChannelId() {
        return channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public Integer getEmptyNumber() {
        return emptyNumber;
    }

    public void setEmptyNumber(Integer emptyNumber) {
        this.emptyNumber = emptyNumber;
    }

    public Integer getProtocol() {
        return protocol;
    }

    public void setProtocol(Integer protocol) {
        this.protocol = protocol;
    }
}
