package com.icetech.cloudcenter.domain.request.pnc;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 端网云架构区域
 */
@ToString
@Setter
@Getter
public class ParkRegionRequest {

    private String regionCode;
    private String regionName;

    /**
     * 区域新能源车是否区分油电和纯电车辆的计费规则，0是不区分 1是区分，默认为0
     */
    private Integer isNewEnergyDiffBill;
    /**
     * 1=添加 2=修改 3=删除
     */
    private Integer operType;
    /**
     *泊位总数
     */
    private Integer regionTotalPark;
    /**
     *空车位数
     */
    private Integer freeSpace;
    /**
     *区域类型 0:顶级 1：非顶级
     */
    private Integer regionType;
    /**
     *父级区域编号,当regionType=1时候，必传
     */
    private String parentCode;

    /**
     *蓝牌车计费规则编号
     */
    private String blueCarBill;
    /**
     *新能源车计费规则编号
     */
    private String newEnergyCarBill;
    /**
     *收费月卡车计费规则编号
     */
    private String fixedCarBill;
    /**
     *  是否有内区域类型 1：是 2：否
     */
    private Integer isSonRegion;
    /**
     * 黄牌车计费规则编号
     */
    private String yellowCarBill;
    /**
     * 区域默认计费规则
     */
    private String defaultBill;
    /**
     * 储值卡车辆计费规则
     */
    private String storedCardBill;

    /**
     * 油电混合计费规则
     */
    private String newEnergyPureEleCarBill;

    /**
     * 在车位满的情况下，是否禁止临时车入内，0：否 1：是
     */
    private Integer isFullForbidEnter;

    /**
     * 在车位满的情况下，是否禁止月卡车入内，0：否 1：是
     */
    private Integer isFullForbidMonthEnter;
    /**
     * 在车位满的情况下，是否禁止VIP车入内，0：否 1：是
     */
    private Integer isFullForbidVIPEnter;
    /**
     * 在车位满的情况下，是否禁止预约车入内，0：否 1：是
     */
    private Integer isFullForbidReservEnter;
    /**
     * 在车位满的情况下，是否禁止储值车入内，0：否 1：是
     */
    private Integer isFullForbidStoreEnter;
    /**
     * 在车位满的情况下，是否禁止黑名单车入内，0：否 1：是
     */
    private Integer isFullForbidBlackEnter;

    /**
     * 剩余多少空车位时，禁止入场，is_full_ forbidenter为1时不能为空
     */
    private Integer fullEmptyNum = 0;
    /**
     * 车场类型id，多个以逗号隔开(在车位满的情况下，是否禁止VIP车入内)
     */
    private String vipCarType;
}
