package com.icetech.cloudcenter.domain.request.pnc;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Getter
@Setter
public class NotifyPrepayRequest {
    private String orderId;
    private String plateNum;
    private String channelId;
    private String tradeNo;
    private String totalPrice;
    private String prepay;
    private String discountPrice;
    private String discountNos;
    private Integer payWay;
    private Integer payChannel;
    private String payTerminal;
    private Long payTime;
    private Integer type;
    private Integer carType;
    private Long parkTime;
    private String merchantTradeNo;
    /**
     * 补缴订单标识，1：入口补缴、2：出口补缴
     */
    private Integer mendPayType;


    @Setter
    @Getter
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class ExtraInfo {
        private String plateNum;
        private String orderId;
        private String channelId;
    }

}
