package com.icetech.cloudcenter.domain.request.pnc;

import lombok.Data;

import java.util.List;

@Data
public class LcdConfigRequest {
    /**
     * 通道编号
     */
    protected String inandoutCode;
    /**
     * 显示屏行数（目前只支持2、3和4），默认是2
     */
    protected Integer lineNum;
    /**
     * 月卡剩余多少天进行提示，默认是0,表示不受限制
     */
    protected Integer remainDaysMc;
    /**
     * 月卡过期小于多少天进行提示，默认是0,表示不受限制
     */
    protected Integer expireDaysMc;
    /**
     * 过期卡车辆按月卡车处理,1是0否
     */
    protected Integer expireDaysMonth;
    /**
     * 黑名单车辆信息是否提示，0提示，1不提示，默认为0
     */
    protected Integer blackCar;
    /**
     * 入口空闲显示布局，1：自定义屏显提示、2：自定义屏显提示+广告、3：全屏广告,默认值是2
     */
    protected Integer entranceFreeLayout;
    /**
     * 入口显示布局，1：自定义屏显提示、2：自定义屏显提示+广告、3：全屏广告
     */
    protected Integer enterLayout;
    /**
     * 出口空闲显示布局，1：自定义屏显提示、2：自定义屏显提示+广告、3：全屏广告
     */
    protected Integer exitFreeLayout;
    /**
     * 出场显示布局，1：自定义屏显提示、2：自定义屏显提示+广告、3：全屏广告
     */
    protected Integer exitLayout;
    /**
     * 恢复默认显示时长，单位是秒，默认是30
     */
    protected Integer restoreDefaultTime;
    /**
     * 音量配置，音量值范围1~10，默认为10
     */
    protected Integer volumeValue;
    /**
     * 勿扰模式是否开启，0不开启，1开启，默认为0
     */
    protected Integer quietHoursSwitch;
    /**
     * 勿扰模式开始时间
     */
    protected String quietStartTime;
    /**
     * 勿扰模式结束时间
     */
    protected String quietEndTime;
    /**
     * 勿扰模式音量音量值范围1~10，默认为1
     */
    protected Integer quietVolumeValue;
    /**
     * 限行类型：0是尾号限行，1是单双号限行，默认为0
     */
    protected Integer limitType;
    /**
     * 周一限行信息，尾号限行填写比如：4和9，单双号限行不填写,默认4和9
     */
    protected String limitDriveNum1;
    /**
     * 周二限行信息，尾号限行填写比如：5和0，单双号限行不填写,默认5和0
     */
    protected String limitDriveNum2;
    /**
     * 周三限行信息，尾号限行填写：1和6，单双号限行不填写,默认1和6
     */
    protected String limitDriveNum3;
    /**
     * 周四限行信息，尾号限行填写：2和7，单双号限行不填写,默认2和7
     */
    protected String limitDriveNum4;
    /**
     * 周五限行信息，尾号限行填写：3和8，单双号限行不填写,默认3和8
     */
    protected String limitDriveNum5;
    /**
     * Lcd屏显亮度配置
     */
    protected List<BrightnessConfig> lcdBrightness;
    /**
     * lcd屏显每行配置
     */
    protected List<DisplayConfig> lcdShow;
    /**
     * lcd进出场提示配置
     */
    protected List<TipsConfig> lcdTips;
    /**
     * lcd语音编码配置
     */
    protected List<SoundCodeConfig> lcdSoundcode;
    /**
     * lcd语音配置
     */
    protected List<SoundConfig> lcdSound;

    protected String regionFreeSpace;

    /**
     * 屏显亮度配置
     */
    @Data
    public static class BrightnessConfig {
        /**
         * 开始时间点，格式为hh:mi
         */
        protected String startTimePoint;
        /**
         * 结束时间点，格式为hh:mi
         */
        protected String endTimePoint;
        /**
         * 亮度值
         */
        protected Integer brightnessVal;
        /**
         * 排序值
         */
        protected Integer sort;
    }

    /**
     * 屏显每行配置
     */
    @Data
    public static class DisplayConfig {
        /**
         * 显示类型 1：入口空闲显示、2：入场显示、3：出口空闲显示、4：出场显示
         */
        protected Integer displayType;
        /**
         * 显示在第几行，1：第一行、2：第二行、3：第三行、4：第四行，目前最多有4行
         */
        protected Integer rowNum;
        /**
         * 显示颜色1：红色，2：绿色，3：黄色，默认第一、三行是1（红色），二、四行时2（绿色）默认是1
         */
        protected Integer rowColor;
        /**
         * 动态内容编号和显示序号，多个之间用”+”符号链接，编号和序号之间用”_”符号链接，动态内容有：1：当前时间、2：今日限号、3：剩余车位、4：车牌号、5：车辆类型、6：月卡剩余天数、7：停车时长、8：入场提示、9：缴费/出场提示、10：需支付金额、11：停车场名称（比如：”4_1+5_3”,动态内容需要显示车牌号和车辆类型，车牌号排第一显示，车辆类型排第三显示）
         */
        protected String dynamicContent;
        /**
         * 自定义内容和显示序号，多个之间用”+”符号链接，内容和序号之间用”_”符号链接(比如”一路平安_2+注意安全_4”,自定义内容中一路平安排第二显示，注意安全排第四显示)
         */
        protected String customContent;
    }

    /**
     * 进出场提示配置
     */
    @Data
    public static class TipsConfig {
        /**
         * 入场临时车/特殊车辆，默认：欢迎光临
         */
        protected String enterTmpSpecial;
        /**
         * 入场月卡车/内部车，默认：欢迎光临
         */
        protected String enterMonthVip;
        /**
         * 入场临时车禁止入场，默认：非月卡车禁止入内
         */
        protected String enterNotAllowTmpRun;
        /**
         * 入场多卡多车情况，车位被占用提示，默认：车位已占
         */
        protected String enterMultiParkCar;
        /**
         * 入场黑名单提示，默认：禁止通行
         */
        protected String enterBlackCar;
        /**
         * 入场月卡过期提示，默认：月卡车已过期
         */
        protected String enterMonthExpire;
        /**
         * 入场没有空车位提示信息，默认：车位已满 禁止入内
         */
        protected String enterNoParkingSpace;
        /**
         * 无牌车入场提示，默认：请扫码入场
         */
        protected String enterNotAllowNocarRun;
        /**
         * 出场缴费提示，默认：请扫码缴费
         */
        protected String exitPay;
        /**
         * 出场开闸提示，默认：一路平安
         */
        protected String exitOpenGate;
        /**
         * 出场无在场记录，默认：无入场信息/请呼叫管理员
         */
        protected String exitNoEnterinfo;
        /**
         * 无牌车出场，默认：请扫码出场
         */
        protected String exitNoCarplate;
        /**
         * 车辆禁止出场提示，默认：禁止通行
         */
        protected String exitNotAllowRun;
    }

    /**
     * 语音编码配置
     */
    @Data
    public static class SoundCodeConfig {
        /**
         * 语音编号
         */
        protected String soundCode;
        /**
         * 语音内容
         */
        protected String content;
        /**
         * 按动静态分类，1：静态，2：动态
         */
        protected Integer type;
        /**
         * 是否自定义语音，1：是，0：否
         */
        protected Integer isCustom;
        /**
         * 定制语音文件地址
         */
        protected String customSoundPath;
    }

    /**
     * 语音配置
     */
    @Data
    public static class SoundConfig {
        /**
         * 按播放场景分类，1：入场临时车/特殊车、2：入场月卡车/内部车辆、3：入场无牌车、 4、车位已满5：出场收费车辆、6：出场支付成功、7：出场月卡车、8：出场无牌车、9：免费车辆（临时/特殊）、10.出场无入场记录、11：临时车禁止通行、12：多位多车车位占用、13黑名单车辆进出场
         */
        protected Integer soundType;
        /**
         * 语音内容模板，多个语音编号之间用"+"连接，语音编号查看ice_lcd_soundcode表（比如："D3+D4”,需要按先后顺序播放车牌号和车辆类型，车牌号先播放，车辆类型后播放）
         */
        protected String contentPattern;
    }
}
