package com.icetech.cloudcenter.domain.request.pnc;

import lombok.Data;

import java.util.List;

@Data
public class ChannelInfoRequest {
    private Integer channelNum;
    private List<ChannelData> channelData;

    @Data
    public static class ChannelData{
        private String channelCode;
        private String channelName;
        private Integer gateType;
        private Integer tempCarRun;
        private Integer noCardRun;
        private Integer yellowCarRun;
        private Integer qrcodeType;
        private Integer vagueType;
        private Integer deviceNum;
        private List<DeviceData> deviceData;
    }
    @Data
    public static class DeviceData{
        private String deviceCode;
        private Integer deviceType;
        private Integer dualCamera;
        private Integer masterCamera;
        private String serialNumber;
        private String ip;
        private String port;
        private Integer callMethods;
        private String videoUrl;

    }
}
