package com.icetech.cloudcenter.domain.request.p2c;

import com.icetech.cloudcenter.domain.base.Request;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.exception.ResponseBodyException;
import lombok.Data;

@Data
public class VisitCardRequest extends Request {
    /**
     * 预约ID
     */
    protected Long visitId;
    /**
     * 车牌号
     */
    protected String plateNum;
    /**
     * 是否收费，0：否，1：是
     */
    protected Integer isCharge;
    /**
     * 是否允许多次进入，0：否，1：是
     */
    protected Integer isInoutMore;
    /**
     * 有效开始时间，格式yyyy-MM-dd hh:mm:ss, 如2019-01-01 00:00:00
     */
    protected String startTime;
    /**
     * 有效结束时间，格式yyyy-MM-dd hh:mm:ss, 如2019-02-01 23:59:59
     */
    protected String endTime;

    @Override
    public Request buildByVersion(String version){
        if (P2cVersionEnum.版本9.getIndex() > P2cVersionEnum.getIndex(version)){
            throw new ResponseBodyException(CodeConstants.ERROR_407, "当前相机版本号过低，无法下发，请升级");
        }
        return this;
    }
}
