package com.icetech.cloudcenter.domain.request.p2c;

import com.icetech.cloudcenter.domain.base.Request;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.exception.ResponseBodyException;
import lombok.Data;

/**
 * 储值卡车辆信息下发
 */
@Data
public class StoredCardRequest extends Request {
    public static final String DATE_PATTERN = "yyyy-MM-dd";

    /**
     * 操作类型1=添加 2=修改 3=删除
     */
    protected Integer operType;
    /**
     * 储值卡ID
     */
    protected Long cardId;
    /**
     * 车主姓名
     */
    protected String cardOwner;
    /**
     * 有效期开始日期，格式为yyyy-MM-dd hh:mm:ss
     */
    protected String startTime;
    /**
     * 有效期结束日期，格式为yyyy-MM-dd hh:mm:ss
     */
    protected String endTime;
    /**
     * 车牌号,可以多个。会以"/"连接。
     */
    protected String plateNums;

    @Override
    public Request buildByVersion(String version){
        if (P2cVersionEnum.版本9.getIndex() > P2cVersionEnum.getIndex(version)){
            throw new ResponseBodyException(CodeConstants.ERROR_407, "当前相机版本号过低，无法下发，请升级");
        }
        return this;
    }
}
