package com.icetech.cloudcenter.domain.request.p2c;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 端云架构远程开关闸参数类
 */
@ToString
@Setter
@Getter
public class RemoteSwitchRequest implements Serializable {

    private Integer switchType;
    private Integer sequenceId;
    private Long time;
    private String plateNum;


    public enum ExtraInfoEnum {
        //移动端查询费用
        OPEN("open"),
        CLOSE("close"),
        STANDARD("standard"),
        ;
        public String val;
        ExtraInfoEnum(String val){
            this.val = val;
        }
    }

    @Setter
    @Getter
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    public static class ExtraInfo<T> {
        private String biz;
        private T requestVO;
    }
}
