package com.icetech.cloudcenter.domain.request.p2c;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 属性设置接口
 */
@ToString
@Setter
@Getter
public class PropertySetRequest implements Serializable {

    private String parkCode;
    private Integer enexType;
    private Integer protocolType;
    /**
     * 滞留算法开关，0：关，1：开
     */
    private Integer retentionAlarm;
    /**
     * 滞留时间阈值，单位秒，范围在30到600，滞留算法开关为1开时生效
     */
    private Integer retentionTimeThreshold;
    private Integer retentionAlarmMethod;
    private Integer retentionIntervalTime;
    /**
     * 是否开启虚假车牌识别功能，0：关闭，1：打开
     */
    private Integer enableShamPlate;
    /**
     * 虚假车牌处理方式，1：报警，2：过滤
     */
    private Integer shamPlateMethod;

}
