package com.icetech.cloudcenter.domain.request.p2c;

import com.icetech.cloudcenter.domain.base.Request;
import com.icetech.cloudcenter.domain.enumeration.P2cVersionEnum;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.exception.ResponseBodyException;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 计费规则与车牌类型对应关系下发
 */
@ToString
@Setter
@Getter
public class ChargePlatetypeRelRequest extends Request {

    private String billtypecode;
    private Integer plateType;
    private Integer regionId = 0;

    @Override
    public Request buildByVersion(String version){
        if (P2cVersionEnum.版本9.getIndex() > P2cVersionEnum.getIndex(version)){
            throw new ResponseBodyException(CodeConstants.ERROR_407, "当前相机版本号过低，无法下发，请升级");
        }
        return this;
    }
}
