package com.icetech.cloudcenter.domain.request;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * Description YuneasyPushCall
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2021/8/9 4:20 下午
 */
@Data
public class YuneasyPushCall implements Serializable {

    /**
     * 参数
     */
    private List<YuneasyPushCallInfo> cdr;

    @Data
    public static class YuneasyPushCallInfo implements Serializable  {
        
        /**
         * 企业编号
         */
        @JsonProperty("company_no")
        private String companyNo;

        /**
         * 电话唯一标识
         */
        @JsonProperty("call_uuid")
        private String callUuid;

        /**
         * 一通电话有多个uuid，以逗号相隔，agent_uuid属于其中之一
         */
        private String uuids;

        /**
         * 呼叫标识，1:呼入 2:手动呼出 3:自动呼出 4:内线 5:环回测试
         */
        @JsonProperty("call_type")
        private Integer callType;

        /**
         * 主叫号
         */
        @JsonProperty("caller_num")
        private String callerNum;

        /**
         * 被叫号
         */
        @JsonProperty("callee_num")
        private String calleeNum;

        /**
         * 开始时间
         */
        @JsonProperty("start_time")
        private String startTime;

        /**
         * 客户通话时长
         */
        @JsonProperty("call_lasts_time")
        private Integer callLastsTime;

        /**
         * 座席通话时长
         */
        @JsonProperty("agent_duration")
        private Integer agentDuration;

        /**
         * 主叫员工工号
         */
        @JsonProperty("caller_agent_num")
        private String callerAgentNum;

        /**
         * 被叫员工工号
         */
        @JsonProperty("callee_agent_num")
        private String calleeAgentNum;

        /**
         * 主叫部门名
         */
        @JsonProperty("caller_agent_group_name")
        private String callerAgentGroupName;

        /**
         * 被叫部门名
         */
        @JsonProperty("callee_agent_group_name")
        private String calleeAgentGroupName;

        /**
         * 满意度评价，1:非常满意 2:满意 3:一般 4:不满意 5:极差
         */
        private Integer grade;

        /**
         * 业务携带标识（c+企业id+ _ +cusData，比如“c1_cusData”）
         */
        private String cusData;

        /**
         * 自动外呼任务ID
         */
        private String taskid;

        /**
         * 自动外呼任务名称
         */
        private String taskname;
        
    }


}
