package com.icetech.cloudcenter.domain.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

@Setter
@Getter
@ToString
public class VisitRequest implements Serializable {
    /**
     *预约记录编码(修改时候用）
     */
    private String visitNum;
    /**
     *
     */
    private String parkCode;
    /**
     *车牌号码（多个逗号分隔）
     */
    private String plateNums;
    /**
     *访客联系方式
     */
    private String visitPhone;
    /**
     *访客姓名
     */
    private String visitName;
    /**
     *业主姓名
     */
    private String masterName;
    /**
     *业主电话
     */
    private String masterPhone;
    /**
     *到访原因
     */
    private String reason;
    /**
     *业主房号
     */
    private String masterNum;

    private Integer pageNo;
    private Integer pageSize;
    @JsonFormat( pattern="yyyy-MM-dd HH:mm",timezone = "GMT+8")
    private Date startTime;
    @JsonFormat( pattern="yyyy-MM-dd HH:mm",timezone = "GMT+8")
    private Date endTime;
    /**
     * 用户id
     */
    private Integer mpUserId;

}
