package com.icetech.cloudcenter.domain.request;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * 远程升级参数
 */
@ToString
@Setter
@Getter
public class UpgradeLogListRequest implements Serializable{

    /**
     * 设备序列号
     */
    private String sn;
    /**
     * 车场ID列表
     */
    private List<Long> parkIdList;
    /**
     * 升级状态
     */
    private Integer taskStatus;
    /**
     * 升级完成的开始时间
     */
    private String startActionTime;

    /**
     * 升级完成的结束时间
     */
    private String endActionTime;
    /**
     * 分页参数
     */
    private Integer pageNo = 1;
    private Integer pageSize = 10;
}
