package com.icetech.cloudcenter.domain.request;

import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class OrderQueryRequest extends BaseQueryRequest {
    /**
     * 车场编号
     */
    private String parkCode;
    private Long parkId;
    /**
     * 状态
     */
    private  String plateNum;
    private  String plateNumber;
    /**
     * 车辆类型
     */
    private List<Integer> types;
    /**
     * 入场开始时间
     */
    private Date enterStartTime;
    /**
     * 入场结束时间
     */
    private Date enterEndTime;
    /**
     * 公众号用户
     */
    private Integer mpUserId;

    /**
     * 车型
     */
    private Integer type;

    /**
     * 置信度
     */
    private Integer reliability;
    /**
     * 是否是无牌车固定收费
     */
    private Integer noplateFee;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 1：多位多车占用，2：使用该车上一次的入场时间计费，3：欠费车辆，4：折返回场，5：虚假车牌，6：补缴车辆
     */
    private List<Integer> tagIds;
    private Integer freeFlag;
    private List<String> channelCodes;
    private String cardOwner;
    private Integer serviceStatus;
    private List<Integer> serviceStatuses;
}
