package com.icetech.cloudcenter.domain.request;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 无牌车入场请求参数
 * @author fangct
 */
@Setter
@Getter
@ToString
public class NoplateExitRequest implements Serializable {
    @NotNull
    private String parkCode;
    @NotNull
    private String channelId;
    @NotNull
    private String plateNum;
    @NotNull
    private Long exitTime;
    private Integer carType;
    private String carDesc;

    private String orderNum;
    private String topic;

    private boolean offLine;
    private Integer exitWay;
    private String operAccount;
    private Integer exitTerminal;

    /**
     * 保留参数
     */
    private PaidInfo paidInfo;

    @Setter
    @Getter
    @ToString
    public static class PaidInfo implements Serializable {
        @NotNull
        private String orderId;
        @NotNull
        private String tradeNo;
        @NotNull
        private String totalPrice;
        @NotNull
        private String paidPrice;
        @NotNull
        private String discountPrice;
        @NotNull
        private Integer payWay;
        @NotNull
        private Long payTime;
    }
}
