package com.icetech.cloudcenter.domain.request;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

@Setter
@Getter
@ToString
public class EnterRequest  implements Serializable {
    private Long parkId;
    @NotNull
    private String orderId;
    @NotNull
    private String plateNum;
    private String channelId;
    @NotNull
    private Long enterTime;
    @NotNull
    private Integer type;
    @NotNull
    private Integer carType;
    private String enterImage;
    private String smallImage;
    private String carDesc;
    private String carBrand;
    private String carColor;
    /**
     * 车牌颜色:蓝色;黄色;白色;黑色;绿色;黄绿色
     */
    private String plateColor;
    private Integer isInside = 0;
    /**
     * 置信度
     */
    private Integer reliability;
    /**
     * 无进场记录标识
     */
    private boolean noneEnterFlag = false;
    private String remark;

    private Integer inoutEvent;
    private Integer exTerminal;
    private String operAccount;

    public boolean getNoneEnterFlag() {
        return noneEnterFlag;
    }
}
