package com.icetech.cloudcenter.domain.request;

import com.icetech.common.annotation.NotNull;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 允许出场请求
 * @author wangzw
 */
@Data
public class DataExitRequest implements Serializable {
    /**
     *车场编号
     */
    @NotNull
    private String parkCode;
    /**
     * 订单号
     */
    @NotNull
    private String orderNum;
    /**
     *通道编号
     */
    @NotNull
    private String aisleCode;
    /**
     *车牌号码
     */
    @NotNull
    private String plateNum;
    /**
     *车辆类型
     */
    @NotNull
    private Integer type;
    /**
     *车型
     */
//    @NotNull
    private Integer carType;
    /**
     *特殊车辆
     */
    private String specialCar;
    /**
     *入场时间
     */
//    @NotNull
    private Date enterTime;
    /**
     *出场时间
     */
    @NotNull
    private Date exitTime;
    /**
     *总应收
     */
//    @NotNull
    private String totalPrice;
    /**
     *实收(已经缴费金额)
     */
//    @NotNull
    private String paidPrice;
    /**
     *总优惠
     */
//    @NotNull
    private String discountPrice;
    /**
     *需支付
     */
//    @NotNull
    private String needPayPrice;
    private boolean offLine;
    private String topic;
    private String operAccount;
    private Integer exitWay;
    private Integer exitTerminal;

}
