package com.icetech.cloudcenter.domain.request;

import com.icetech.common.annotation.NotNull;
import lombok.Data;

import java.io.Serializable;

/**
 * 允许出场请求
 * @author wangzw
 */
@Data
public class DataEnterRequest implements Serializable {
    /**
     * 车场编号
     */
    @NotNull
    private String parkCode;

    private String orderNum;
    /**
     * 通道编号
     */
    @NotNull
    private String aisleCode;
    /**
     * 车牌号
     */
    @NotNull
    private String plateNum;
    /**
     * 车辆类型
     */
    private Integer type;
    /**
     * 车型
     */
    private Integer carType;
    /**
     * 特殊车辆
     */
    private String specialCar;

    /**
     * 无牌车时必传
     */
    private Long enterTime;
    /**
     * 是否调试模式
     */
    private boolean isDebug = false;
    /**
     * 操作用户
     */
    private String operaUser;
    /**
     * 是否离线模式
     */
    private boolean offLine;
    private String topic;
    private String remark;
    /**
     * 来源，2：云岗亭小程序，3：中央收费站，4：远程监控客服坐席，5：本地坐席6：APP，默认为2
     */
    private Integer enterTerminal;
    /**
     * 入场方式
     */
    private Integer enterWay;

}
