package com.icetech.cloudcenter.domain.request;

import com.icetech.common.annotation.NotNull;
import lombok.Data;

import java.io.Serializable;

/**
 * 批量下发请求
 * @author fangct
 */
@Data
public class BatchSendActionRequest implements Serializable{

    /**
     *车场编号
     */
    @NotNull
    private Long parkId;
    /**
     *配置类型（101：高级配置，102：通道信息 ，103：计费规则，104：屏显配置）
     */
    private String configTypes;
    /**
     *多个业务类型（201：月卡车、202：黑名单、203：VIP车辆、204：优惠、205：访客车辆）
     */
    private String bizTypes;
    /**
     *通道ID
     */
    private String channelIds;
    /**
     * 操作人账号
     */
    @NotNull
    private String operAccount;

}
